/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.table.models;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.slidertext.SliderTextContainer;
import org.gvsig.gui.beans.table.models.JValueSelector;

class ValueSelector
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1510744508318912657L;
    private int initValue;
    private ActionListener okListener;
    private ActionListener cancelListener;
    private int HBUTTONS = 30;
    private int HSLIDER = 50;
    private JPanel buttons = null;
    private JPanel pMain = null;
    private SliderTextContainer pSlider = null;
    private int width = 315;
    private int height = 115;
    private int widthMargin = 300;
    private JButton bAccept = null;
    private JButton bCancel = null;

    public ValueSelector(Component c, String title, boolean modal, JValueSelector valueSelector, ActionListener okListener, ActionListener cancelListener, String initValue) throws HeadlessException {
        super(JOptionPane.getFrameForComponent(c), title, modal);
        this.okListener = okListener;
        this.cancelListener = cancelListener;
        try {
            this.init(Integer.valueOf(initValue));
            this.initValue = Integer.valueOf(initValue);
        }
        catch (NumberFormatException ex) {
            this.init(0);
        }
        this.setLocationRelativeTo(c);
    }

    public void init(int initValue) {
        this.getPSlider().setValue(initValue);
        Container contentPane = this.getContentPane();
        FlowLayout layout = new FlowLayout();
        layout.setHgap(0);
        layout.setVgap(0);
        contentPane.setLayout(layout);
        this.setSize(this.width, this.height + 10);
        contentPane.add((Component)this.getPMain(), null);
    }

    public void setValue(int value) {
        this.initValue = value;
        this.getPSlider().setValue(value);
    }

    public double getValue() {
        return this.initValue;
    }

    private JPanel getPMain() {
        if (this.pMain == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.gridx = 0;
            this.pMain = new JPanel();
            this.pMain.setLayout(new GridBagLayout());
            this.pMain.setPreferredSize(new Dimension(this.widthMargin, this.height));
            this.pMain.add((Component)this.getPSlider(), gridBagConstraints);
            this.pMain.add((Component)this.getPButtons(), gridBagConstraints1);
        }
        return this.pMain;
    }

    private JPanel getPButtons() {
        if (this.buttons == null) {
            this.buttons = new JPanel();
            this.buttons.setPreferredSize(new Dimension(this.widthMargin, this.HBUTTONS));
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            flowLayout.setVgap(0);
            flowLayout.setHgap(2);
            this.buttons.setLayout(flowLayout);
            this.buttons.add((Component)this.getBAccept(), null);
            this.buttons.add((Component)this.getBCancel(), null);
        }
        return this.buttons;
    }

    public SliderTextContainer getPSlider() {
        if (this.pSlider == null) {
            this.pSlider = new SliderTextContainer(0, 255, this.initValue);
            this.pSlider.setPreferredSize(new Dimension(this.widthMargin, this.HSLIDER));
        }
        return this.pSlider;
    }

    public JButton getBAccept() {
        if (this.bAccept == null) {
            this.bAccept = new JButton("aceptar");
            this.bAccept.addActionListener(this.okListener);
            this.bAccept.addActionListener(this);
        }
        return this.bAccept;
    }

    public JButton getBCancel() {
        if (this.bCancel == null) {
            this.bCancel = new JButton("cancelar");
            this.bAccept.addActionListener(this.cancelListener);
            this.bCancel.addActionListener(this);
        }
        return this.bCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBAccept()) {
            this.initValue = (int)this.getPSlider().getValue();
        }
        this.setVisible(false);
    }
}

