/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Bytearray;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;

public class JDynFormFieldBytearray
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected byte[] assignedValue = null;
    protected byte[] currentValue = null;
    protected JTextComponent jtext = null;
    protected JButton jbuttonUpload = null;
    protected JButton jbuttonDownload = null;
    protected JButton jbuttonEditAsText = null;
    private PickerController<byte[]> picker;

    public JDynFormFieldBytearray(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (byte[])value;
    }

    public void setReadOnly(boolean readonly) {
        JComponent theJlabel = this.getJLabel();
        if (this.jlabel != null) {
            this.jlabel.setEnabled(!readonly);
        } else if (theJlabel != null) {
            theJlabel.setEnabled(!readonly);
        }
        this.readOnly = readonly;
        if (this.picker != null) {
            this.picker.setEnabled(!this.isReadOnly());
        }
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout());
        DynFormSPIManager.ComponentsFactory componentsFactory = this.getComponentsFactory();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.jtext = componentsFactory.getJTextField(this.getDefinition(), null);
        this.jbuttonDownload = componentsFactory.getJButton(this.getDefinition(), "Download");
        this.jbuttonUpload = componentsFactory.getJButton(this.getDefinition(), "Upload");
        this.jbuttonEditAsText = componentsFactory.getJButton(this.getDefinition(), "EditAsText");
        this.picker = toolsSwingManager.createByteArrayPickerController((JTextComponent)((JTextField)this.jtext), this.jbuttonUpload, this.jbuttonDownload, this.jbuttonEditAsText, this.getForm().getDefinition().getName() + ".RAWDATA", null);
        this.picker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JDynFormFieldBytearray.this.fireFieldChangedEvent();
            }
        });
        if (!componentsFactory.containsComponents(this.getDefinition())) {
            toolsSwingManager.removeBorder((JComponent)this.jbuttonDownload);
            toolsSwingManager.removeBorder((JComponent)this.jbuttonUpload);
            toolsSwingManager.removeBorder((JComponent)this.jbuttonEditAsText);
            JPanel buttons = new JPanel(new FlowLayout(4, 4, 2));
            buttons.add(this.jbuttonUpload);
            buttons.add(this.jbuttonDownload);
            if (this.jbuttonEditAsText != null) {
                buttons.add(this.jbuttonEditAsText);
            }
            this.contents.add((Component)this.jtext, "Center");
            this.contents.add((Component)buttons, "After");
            this.contents.setVisible(true);
        }
        this.picker.setEnabled(!this.isReadOnly());
        this.setValue(this.assignedValue);
    }

    public void setValue(Object value) {
        this.picker.set((Object)((byte[])value));
        this.assignedValue = (byte[])value;
    }

    public Object getValue() {
        return this.picker.get();
    }

    public boolean hasValidValue() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void clear() {
        this.picker.set(null);
    }

    public boolean isModified() {
        try {
            byte[] value = (byte[])this.picker.get();
            return !Objects.equals(value, this.getAssignedValue());
        }
        catch (Exception ex) {
            return false;
        }
    }
}

