/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Timestamp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.freixas.jcalendar.JCalendar;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class JDynFormFieldTimestamp
extends AbstractJDynFormField
implements JDynFormField {
    protected Object assignedValue = null;
    private JCalendar jcalendar = null;
    private JButton button = null;
    private boolean readonly = false;
    private JTextComponent txtTimestamp;
    private final DocumentListener documentListener;
    private final FocusListener focusListener;

    public JDynFormFieldTimestamp(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = value;
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JDynFormFieldTimestamp.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    Object value = JDynFormFieldTimestamp.this.getValue();
                    if (value != null) {
                        JDynFormFieldTimestamp.this.txtTimestamp.setText(StringUtils.rightPad((String)((Timestamp)value).toString(), (int)29, (char)'0'));
                        JDynFormFieldTimestamp.this.problemIndicator().clear();
                    }
                }
                catch (Exception ex) {
                    JDynFormFieldTimestamp.this.problemIndicator().set(ex.getLocalizedMessage());
                }
                JDynFormFieldTimestamp.this.fireFieldExitEvent();
            }
        };
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JDynFormFieldTimestamp.this.updateProblemIndicator();
                JDynFormFieldTimestamp.this.fireFieldChangedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JDynFormFieldTimestamp.this.updateProblemIndicator();
                JDynFormFieldTimestamp.this.fireFieldChangedEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JDynFormFieldTimestamp.this.updateProblemIndicator();
                JDynFormFieldTimestamp.this.fireFieldChangedEvent();
            }
        };
    }

    public void setReadOnly(boolean readonly) {
        JComponent theJlabel = this.getJLabel();
        if (this.jlabel != null) {
            this.jlabel.setEnabled(!readonly);
        } else if (theJlabel != null) {
            theJlabel.setEnabled(!readonly);
        }
        this.readonly = readonly;
        if (this.contents != null) {
            if (readonly) {
                this.txtTimestamp.setEditable(false);
                this.button.setEnabled(false);
            } else {
                this.txtTimestamp.setEditable(true);
                this.button.setEnabled(true);
            }
        }
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    protected JButton getJButton() {
        return this.button;
    }

    protected JCalendar getJCalendar() {
        if (this.jcalendar == null) {
            this.jcalendar = new JCalendar(3, false);
            this.jcalendar.setNullAllowed(true);
            this.jcalendar.addDateListener(arg0 -> this.doJCalendarChanged());
        }
        return this.jcalendar;
    }

    private void doJCalendarChanged() {
        Date newDate;
        Timestamp currentDate = null;
        try {
            currentDate = (Timestamp)this.getValue();
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get current value", (Throwable)ex);
        }
        if (currentDate == null) {
            currentDate = new Timestamp(new Date().getTime());
        }
        if ((newDate = this.getJCalendar().getDate()) == null) {
            return;
        }
        currentDate.setDate(newDate.getDate());
        currentDate.setMonth(newDate.getMonth());
        currentDate.setYear(newDate.getYear());
        this.txtTimestamp.setText(StringUtils.rightPad((String)currentDate.toString(), (int)29, (char)'0'));
        try {
            this.getDefinition().validate((Object)currentDate);
            this.problemIndicator().clear();
        }
        catch (DynFieldValidateException e) {
            this.problemIndicator().set(e.getLocalizedMessage());
        }
        this.fireFieldChangedEvent();
    }

    public void initComponent() {
        DynObjectValueItem[] availableValues = this.getDefinition().getAvailableValues();
        if (availableValues == null) {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            this.contents = new JPanel();
            this.txtTimestamp = this.getComponentsFactory().getJTextField(this.getDefinition(), null);
            this.txtTimestamp.removeFocusListener(this.focusListener);
            this.txtTimestamp.getDocument().removeDocumentListener(this.documentListener);
            this.button = this.getComponentsFactory().getJButton(this.getDefinition(), null);
            if (this.button == null) {
                this.button = new JButton();
            }
            toolsSwingManager.addClearButton(this.txtTimestamp);
            toolsSwingManager.setDefaultPopupMenu(this.txtTimestamp);
            this.txtTimestamp.addFocusListener(this.focusListener);
            this.txtTimestamp.getDocument().addDocumentListener(this.documentListener);
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.button, (String)"_Show_calendar", (String)"picker-date", e -> this.doShowCalendar(), (FocusListener)this.focusListener);
            this.contents.addFocusListener((FocusListener)((Object)this));
            if (this.getDefinition().isReadOnly()) {
                this.txtTimestamp.setEnabled(false);
                this.getJButton().setEnabled(false);
            }
            this.contents.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            this.contents.add((Component)this.txtTimestamp, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 2;
            c.gridy = 0;
            c.weightx = 0.0;
            this.contents.add((Component)this.button, c);
        }
        this.setValue(this.assignedValue);
    }

    private void doShowCalendar() {
        this.fireFieldEnterEvent();
        JPopupMenu menu = new JPopupMenu();
        try {
            Date v = (Date)this.getValue();
            this.getJCalendar().setDate(v);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't asign date to calendar");
            this.getJCalendar().setDate(null);
        }
        menu.add((Component)this.getJCalendar());
        menu.show(this.txtTimestamp, 0, this.txtTimestamp.getY() + 22);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.txtTimestamp.setText("");
        } else {
            this.txtTimestamp.setText(StringUtils.rightPad((String)((Timestamp)value).toString(), (int)29, (char)'0'));
        }
        try {
            this.getDefinition().validate(value);
            this.problemIndicator().clear();
        }
        catch (DynFieldValidateException e) {
            this.problemIndicator().set(e.getLocalizedMessage());
        }
        this.assignedValue = value;
    }

    public Object getValue() {
        try {
            String ss = this.txtTimestamp.getText();
            if (StringUtils.isBlank((CharSequence)ss)) {
                this.getDefinition().validate(null);
                this.problemIndicator().clear();
                return null;
            }
            Date value = null;
            try {
                value = Timestamp.valueOf(ss);
            }
            catch (Exception ex) {
                value = null;
            }
            if (value == null) {
                try {
                    value = SimpleDateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).parse(ss);
                    value = new Timestamp(((Date)value).getTime());
                }
                catch (Exception ex) {
                    value = null;
                }
            }
            if (value == null) {
                try {
                    value = SimpleDateFormat.getDateInstance(3, Locale.getDefault()).parse(ss);
                    value = new Timestamp(((Date)value).getTime());
                }
                catch (Exception ex) {
                    value = null;
                }
            }
            if (value == null) {
                this.problemIndicator().set("Formato de fecha incorrecto");
            } else {
                this.getDefinition().validate((Object)value);
                this.problemIndicator().clear();
            }
            return value;
        }
        catch (DynFieldValidateException e) {
            throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getLocalizedMessage());
        }
    }

    public boolean hasValidValue() {
        try {
            Object object = this.getValue();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isModified() {
        Timestamp assigned = (Timestamp)this.getAssignedValue();
        String ss = this.txtTimestamp.getText();
        if (StringUtils.isBlank((CharSequence)ss)) {
            return assigned != null;
        }
        try {
            Timestamp value = Timestamp.valueOf(ss);
            return !Objects.equals(value, assigned);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void updateProblemIndicator() {
        try {
            Object value = this.getValue();
            if (value != null) {
                this.problemIndicator().clear();
            }
        }
        catch (Exception ex) {
            this.problemIndicator().set(ex.getLocalizedMessage());
        }
    }
}

