/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.line;

import com.jeta.forms.components.line.LineComponent;
import com.jeta.forms.store.properties.LineProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.util.Iterator;

public class HorizontalLineComponent
extends LineComponent {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;

    public boolean isHorizontal() {
        return true;
    }

    public void paintComponent(Graphics g) {
        int y1 = 0;
        int x1 = 0;
        int x2 = 0;
        Insets insets = this.getInsets();
        x1 = insets.left;
        int width = this.getWidth() - (insets.left + insets.right);
        if (width < 0) {
            return;
        }
        x2 = width + x1;
        int total_thickness = this.getThickness();
        if (this.getPosition() == 0) {
            y1 = (this.getHeight() - total_thickness) / 2;
        } else if (this.getPosition() != 1) {
            y1 = this.getHeight() - total_thickness;
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke old_stroke = g2.getStroke();
        Color old_color = g2.getColor();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            LineProperty prop = (LineProperty)iter.next();
            Stroke s = prop.getStroke();
            g2.setStroke(s);
            g2.setColor(prop.getColor());
            int y = y1 + prop.getThickness() / 2;
            g2.drawLine(x1, y, x2, y);
            y1 += prop.getThickness();
        }
        g2.setColor(old_color);
        g2.setStroke(old_stroke);
    }
}

