/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans.factories;

import com.jeta.forms.components.label.JETALabel;
import com.jeta.forms.gui.beans.BeanProperties;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.factories.JComponentBeanFactory;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.store.properties.TransformOptionsProperty;
import com.jeta.forms.store.properties.effects.PaintProperty;
import com.jeta.forms.support.UserProperties;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import javax.swing.JLabel;

public class LabelBeanFactory
extends JComponentBeanFactory {
    public static final String ID_DEFAULT_HORIZONTAL_ALIGNMENT = "label.h.align";

    public LabelBeanFactory() {
        super(JETALabel.class);
    }

    public void defineProperties(BeanProperties props) {
        super.defineProperties(props);
        TransformOptionsProperty hprop = new TransformOptionsProperty("horizontalAlignment", "getHorizontalAlignment", "setHorizontalAlignment", new Object[][]{{"LEFT", new Integer(2)}, {"CENTER", new Integer(0)}, {"RIGHT", new Integer(4)}, {"LEADING", new Integer(10)}, {"TRAILING", new Integer(11)}});
        TransformOptionsProperty htprop = new TransformOptionsProperty("horizontalTextPosition", "getHorizontalTextPosition", "setHorizontalTextPosition", new Object[][]{{"LEFT", new Integer(2)}, {"CENTER", new Integer(0)}, {"RIGHT", new Integer(4)}, {"LEADING", new Integer(10)}, {"TRAILING", new Integer(11)}});
        TransformOptionsProperty vprop = new TransformOptionsProperty("verticalAlignment", "getVerticalAlignment", "setVerticalAlignment", new Object[][]{{"TOP", new Integer(1)}, {"CENTER", new Integer(0)}, {"BOTTOM", new Integer(3)}});
        TransformOptionsProperty vtprop = new TransformOptionsProperty("verticalTextPosition", "getVerticalTextPosition", "setVerticalTextPosition", new Object[][]{{"TOP", new Integer(1)}, {"CENTER", new Integer(0)}, {"BOTTOM", new Integer(3)}});
        htprop.setPreferred(false);
        vtprop.setPreferred(false);
        props.register(hprop);
        props.register(htprop);
        props.register(vprop);
        props.register(vtprop);
        props.register(new PaintProperty());
        props.setPreferred("font", true);
    }

    public JETABean createBean(String compName, boolean instantiateBean, boolean setDefaults) throws FormException {
        JETABean jbean = super.createBean(compName, instantiateBean, setDefaults);
        Component comp = jbean.getDelegate();
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            String bname = this.getShortBeanClassName();
            if ("JETALabel".equals(bname)) {
                bname = "JLabel";
            }
            if (setDefaults) {
                label.setText(bname);
            }
            try {
                String default_halign;
                UserProperties props = (UserProperties)JETARegistry.lookup("forms.user.properties");
                if (props != null && (default_halign = props.getProperty(ID_DEFAULT_HORIZONTAL_ALIGNMENT, null)) != null && setDefaults) {
                    label.setHorizontalAlignment(LabelBeanFactory.getHorizontalAlignment(default_halign));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return jbean;
    }

    public static String getHorizontalAlignmentString(int halign) {
        if (halign == 2) {
            return "LEFT";
        }
        if (halign == 0) {
            return "CENTER";
        }
        if (halign == 4) {
            return "RIGHT";
        }
        if (halign == 11) {
            return "TRAILING";
        }
        if (halign == 10) {
            return "LEADING";
        }
        return "LEFT";
    }

    public static int getHorizontalAlignment(String halign) {
        if ("LEFT".equalsIgnoreCase(halign)) {
            return 2;
        }
        if ("CENTER".equalsIgnoreCase(halign)) {
            return 0;
        }
        if ("RIGHT".equalsIgnoreCase(halign)) {
            return 4;
        }
        if ("TRAILING".equalsIgnoreCase(halign)) {
            return 11;
        }
        if ("LEADING".equalsIgnoreCase(halign)) {
            return 10;
        }
        return 2;
    }
}

