/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.DynamicBeanInfo;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETABeanFactory;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponentFactory;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.form.ReadOnlyConstraints;
import com.jeta.forms.gui.form.StandardComponent;
import com.jeta.forms.gui.formmgr.FormManager;
import com.jeta.forms.gui.formmgr.FormManagerUtils;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.bean.BeanDeserializer;
import com.jeta.forms.store.bean.BeanSerializer;
import com.jeta.forms.store.bean.BeanSerializerFactory;
import com.jeta.forms.store.memento.BeanMemento;
import com.jeta.forms.store.memento.CellConstraintsMemento;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.memento.StateRequest;
import com.jeta.open.registry.JETARegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JLabel;

public class FormComponent
extends GridComponent {
    private String m_id;
    private boolean m_embedded = false;
    private String m_abspath = null;
    private boolean m_top_level_form = false;
    private FocusPolicyMemento m_focus_policy;
    static /* synthetic */ Class class$com$jeta$forms$gui$form$StandardComponent;

    protected FormComponent() {
    }

    protected FormComponent(String id, JETABean jbean, GridView parentView, boolean embedded) throws FormException {
        super(jbean, parentView);
        this.m_id = id;
        FormUtils.safeAssert(jbean.getDelegate() instanceof GridView);
        this.setBean(this.getBean());
        this.m_embedded = embedded;
    }

    public static FormComponent create() {
        FormComponentFactory factory = (FormComponentFactory)JETARegistry.lookup("form.component.factory");
        if (factory == null) {
            FormUtils.safeAssert(!FormUtils.isDesignMode());
            return new FormComponent();
        }
        return factory.createFormComponent();
    }

    public String getAbsolutePath() {
        return this.m_abspath;
    }

    public int getCellWidth() {
        if (this.getParentView() == null) {
            return this.getWidth();
        }
        return super.getCellWidth();
    }

    public int getCellHeight() {
        if (this.getParentView() == null) {
            return this.getHeight();
        }
        return super.getCellHeight();
    }

    public int getCellX() {
        if (this.getParentView() == null) {
            return this.getX();
        }
        return super.getCellX();
    }

    public int getCellY() {
        if (this.getParentView() == null) {
            return this.getY();
        }
        return super.getCellY();
    }

    public GridView getChildView() {
        JETABean bean = this.getBean();
        if (bean != null) {
            return (GridView)bean.getDelegate();
        }
        return null;
    }

    public int getColumnCount() {
        GridView view = this.getChildView();
        return view == null ? 0 : view.getColumnCount();
    }

    public String getFileName() {
        String path;
        if (this.isLinked() && (path = this.getAbsolutePath()) != null) {
            int pos = path.lastIndexOf(47);
            if (pos < 0) {
                pos = path.lastIndexOf(92);
            }
            if (pos >= 0) {
                return path.substring(pos + 1, path.length());
            }
            return path;
        }
        return null;
    }

    public FocusPolicyMemento getFocusPolicy() {
        return this.m_focus_policy;
    }

    public GridComponent getGridComponent(int col, int row) {
        GridView view = this.getChildView();
        return view == null ? null : view.getGridComponent(col, row);
    }

    public static FormComponent getParentForm(Component comp) {
        if (comp == null) {
            return null;
        }
        for (comp = comp.getParent(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof FormComponent)) continue;
            return (FormComponent)comp;
        }
        return null;
    }

    public FormComponent getParentForm() {
        return FormComponent.getParentForm(this);
    }

    public GridComponent getSelectedComponent() {
        if (this.isSelected()) {
            return this;
        }
        return this.getChildView().getSelectedComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormMemento getExternalState(StateRequest si) throws FormException {
        try {
            JETARegistry.rebind("state.request", si);
            this.setTopLevelForm(true);
            FormMemento formMemento = (FormMemento)this.getState(si);
            return formMemento;
        }
        finally {
            this.setTopLevelForm(false);
            JETARegistry.rebind("state.request", null);
        }
    }

    public int getRowCount() {
        GridView view = this.getChildView();
        return view == null ? 0 : view.getRowCount();
    }

    public ComponentMemento getState(StateRequest si) throws FormException {
        FormMemento state = new FormMemento();
        GridView view = this.getChildView();
        state.setId(this.getId());
        state.setComponentClass(FormComponent.class.getName());
        state.setFocusPolicy(this.m_focus_policy);
        if (this.getParentView() != null) {
            state.setCellConstraints(this.getConstraints().createCellConstraints());
        }
        if (this.isLinked() && si.isShallowCopy()) {
            state.setRelativePath(this.getRelativePath());
            if (!this.isTopLevelForm()) {
                return state;
            }
        }
        state.setRowGroups(view.getRowGroups());
        state.setColumnGroups(view.getColumnGroups());
        state.setRowSpecs(view.getRowSpecs());
        state.setColumnSpecs(view.getColumnSpecs());
        state.setCellPainters(view.getCellPainters());
        Iterator iter = view.gridIterator();
        while (iter.hasNext()) {
            GridComponent gc = (GridComponent)iter.next();
            if (gc.getBean() == null) continue;
            ComponentMemento ccm = gc.getState(si);
            state.addComponent(ccm);
        }
        BeanSerializerFactory fac = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
        BeanSerializer bs = fac.createSerializer();
        JETABean jbean = this.getBean();
        FormUtils.safeAssert(jbean.getDelegate() == view);
        PropertiesMemento pm = bs.writeBean(jbean);
        state.setPropertiesMemento(pm);
        return state;
    }

    public String getId() {
        if (this.isEmbedded()) {
            if (this.m_id == null) {
                this.m_id = "embedded." + String.valueOf(this.hashCode());
            }
            return this.m_id;
        }
        if (this.m_abspath == null) {
            if (this.m_id == null) {
                this.m_id = "linked." + String.valueOf(this.hashCode());
            }
            return this.m_id;
        }
        return this.m_abspath;
    }

    public String getRelativePath() {
        ProjectManager pmgr = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
        return pmgr.getRelativePath(this.m_abspath);
    }

    public static FormComponent getTopLevelForm(Component comp) {
        if (comp == null) {
            return null;
        }
        while (comp != null && !(comp instanceof Window)) {
            if (comp instanceof FormComponent && ((FormComponent)comp).isTopLevelForm()) {
                return (FormComponent)comp;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public boolean isEmbedded() {
        return this.m_embedded;
    }

    public boolean isLinked() {
        return !this.isEmbedded();
    }

    public Iterator gridIterator() {
        return this.getChildView().gridIterator();
    }

    public boolean isTopLevelForm() {
        return this.m_top_level_form;
    }

    protected FormComponent openLinkedForm(FormMemento fm) throws FormException {
        FormComponent fc = FormManagerUtils.openPackagedForm(fm.getRelativePath());
        return fc;
    }

    public void _postInitialize(FormPanel panel, Container cc) {
        if (cc == null) {
            return;
        }
        for (int index = 0; index < cc.getComponentCount(); ++index) {
            Component comp = cc.getComponent(index);
            if (comp instanceof GridComponent) {
                ((GridComponent)comp).postInitialize(panel);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this._postInitialize(panel, (Container)comp);
        }
    }

    public void postInitialize(FormPanel panel) {
        this._postInitialize(panel, this);
    }

    protected void postSetState(ComponentMemento cm) {
        GridComponent gc;
        GridView view = this.getChildView();
        block0: for (int col = 1; col <= view.getColumnCount(); ++col) {
            for (int row = 1; row <= view.getRowCount(); ++row) {
                gc = view.getGridComponent(col, row);
                if (gc != null) continue;
                gc = new StandardComponent(null, view);
                gc.setPreferredSize(new Dimension(10, 10));
                gc.setMinimumSize(new Dimension(10, 10));
                view.addComponent(gc, new ReadOnlyConstraints(col, row));
                continue block0;
            }
        }
        block2: for (int row = 2; row <= view.getRowCount(); ++row) {
            for (int col = 1; col <= view.getColumnCount(); ++col) {
                gc = view.getGridComponent(col, row);
                if (gc != null) continue;
                gc = new StandardComponent(null, view);
                gc.setPreferredSize(new Dimension(10, 10));
                gc.setMinimumSize(new Dimension(10, 10));
                view.addComponent(gc, new ReadOnlyConstraints(col, row));
                continue block2;
            }
        }
    }

    public void print() {
        FormsLogger.debug("FormComponent  name = " + this.getName() + "   uid = " + this.getId() + "  path = " + this.getAbsolutePath() + "  hash: " + this.hashCode() + "   parentView: " + this.getParentView());
    }

    public void revalidate() {
        GridView view = this.getChildView();
        if (view != null) {
            view.revalidate();
        }
        super.revalidate();
    }

    protected void setBean(JETABean jbean) {
        super.setBean(jbean);
        FormUtils.safeAssert(jbean.getDelegate() instanceof GridView);
        this.setLayout(new BorderLayout());
        FormUtils.safeAssert(this.getComponentCount() == 0);
        this.removeAll();
        this.add((Component)jbean, "Center");
    }

    public void setAbsolutePath(String path) {
        this.m_abspath = path;
        if (path != null) {
            this.m_embedded = false;
        }
    }

    public void setControlButtonsVisible(boolean bVisible) {
    }

    public void setFocusPolicy(FocusPolicyMemento fm) {
        this.m_focus_policy = fm;
    }

    public void setSelected(boolean bsel) {
        super.setSelected(bsel);
        if (!bsel) {
            GridView gv = this.getChildView();
            gv.deselectAll();
        }
    }

    public void setState(ComponentMemento memento) throws FormException {
        FormMemento state = (FormMemento)memento;
        if (state.getRelativePath() == null) {
            this.m_embedded = true;
        }
        this.m_focus_policy = state.getFocusPolicy();
        FormManager fmgr = (FormManager)JETARegistry.lookup("jeta.forms.formmanager");
        if (FormUtils.isDesignMode()) {
            FormUtils.safeAssert(fmgr != null);
        }
        JETABean viewbean = JETABeanFactory.createBean("com.jeta.forms.gui.form.GridView", "gridview", true, true);
        GridView view = (GridView)viewbean.getDelegate();
        view.initialize(state.getColumnSpecs(), state.getRowSpecs());
        view.setCellPainters(state.getCellPainters());
        this.setBean(viewbean);
        view.setRowGroups(state.getRowGroups());
        view.setColumnGroups(state.getColumnGroups());
        PropertiesMemento pm = state.getPropertiesMemento();
        if (pm != null) {
            BeanSerializerFactory fac = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
            BeanDeserializer bds = fac.createDeserializer(pm);
            bds.initializeBean(viewbean);
        } else {
            try {
                HashMap props = state.getProperties();
                DynamicBeanInfo beaninfo = viewbean.getBeanInfo();
                Collection jpds = beaninfo.getPropertyDescriptors();
                Iterator iter = jpds.iterator();
                while (iter.hasNext()) {
                    JETAPropertyDescriptor jpd = (JETAPropertyDescriptor)iter.next();
                    Object value = props.get(jpd.getName());
                    if (value == null) continue;
                    jpd.setPropertyValue(viewbean, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator iter = state.iterator();
        while (iter.hasNext()) {
            ComponentMemento cm = (ComponentMemento)iter.next();
            try {
                BeanMemento bm;
                FormMemento fm;
                if (cm instanceof FormMemento && (fm = (FormMemento)cm).getRelativePath() != null) {
                    try {
                        FormComponent fc = this.openLinkedForm(fm);
                        view.addComponent((GridComponent)fc, fm.getCellConstraintsMemento().createCellConstraints());
                    }
                    catch (Exception e) {
                        JLabel elabel = new JLabel("Error: " + fm.getRelativePath());
                        elabel.setForeground(Color.red);
                        JETABean bean = new JETABean(elabel);
                        StandardComponent gc = new StandardComponent(bean, view);
                        view.addComponent((GridComponent)gc, fm.getCellConstraintsMemento().createCellConstraints());
                        FormsLogger.severe(e);
                    }
                    continue;
                }
                CellConstraintsMemento ccm = cm.getCellConstraintsMemento();
                if ((class$com$jeta$forms$gui$form$StandardComponent == null ? FormComponent.class$("com.jeta.forms.gui.form.StandardComponent") : class$com$jeta$forms$gui$form$StandardComponent).getName().equals(cm.getComponentClass()) && cm instanceof BeanMemento && (bm = (BeanMemento)cm).getBeanClass() == null) continue;
                GridComponent gc = null;
                Class<?> gc_class = Class.forName(cm.getComponentClass());
                gc = (class$com$jeta$forms$gui$form$FormComponent == null ? FormComponent.class$("com.jeta.forms.gui.form.FormComponent") : class$com$jeta$forms$gui$form$FormComponent).isAssignableFrom(gc_class) ? FormComponent.create() : (GridComponent)gc_class.newInstance();
                gc.setState(cm);
                if (ccm == null) {
                    System.out.println("FormComponent.setState cellconstraints memento is null: ");
                    gc.print();
                    FormUtils.safeAssert(false);
                    continue;
                }
                view.addComponent(gc, ccm.createCellConstraints());
            }
            catch (Exception e) {
                FormsLogger.severe(e);
            }
        }
        this.postSetState(memento);
        view.refreshView();
    }

    public void setTopLevelForm(boolean topLevel) {
        this.m_top_level_form = topLevel;
    }
}

