/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BorderProperty
extends JETAProperty {
    static final long serialVersionUID = -9007148666135189228L;
    public static final int VERSION = 4;
    private boolean m_top = true;
    private boolean m_left = true;
    private boolean m_right = true;
    private boolean m_bottom = true;
    private boolean m_include_title;
    private String m_title;
    private int m_justification = 0;
    private int m_position = 0;
    private static ColorProperty DEFAULT_TEXT_COLOR;
    private ColorProperty m_text_color = new ColorProperty("TitledBorder.titleColor");
    public static final String PROPERTY_ID = "border";
    static final /* synthetic */ boolean $assertionsDisabled;

    public BorderProperty() {
        super(PROPERTY_ID);
    }

    public Border createBorder(Component comp) {
        return null;
    }

    public Border createTitle(Border b) {
        if (this.isIncludeTitle()) {
            return BorderFactory.createTitledBorder(b, this.getTitle(), this.getJustification(), this.getPosition(), this.getTextFont(), this.getTextColor());
        }
        return b;
    }

    public boolean equals(Object object) {
        if (object instanceof BorderProperty) {
            BorderProperty bp = (BorderProperty)object;
            return super.equals(object) && this.m_top == bp.m_top && this.m_left == bp.m_left && this.m_right == bp.m_right && this.m_bottom == bp.m_bottom && this.m_include_title == bp.m_include_title && BorderProperty.isEqual(this.m_title, bp.m_title) && this.m_justification == bp.m_justification && this.m_position == bp.m_position && BorderProperty.isEqual(this.m_text_color, bp.m_text_color);
        }
        return false;
    }

    public static int fromPositionString(String pos) {
        if ("ABOVE_TOP".equals(pos)) {
            return 1;
        }
        if ("TOP".equals(pos)) {
            return 2;
        }
        if ("BELOW_TOP".equals(pos)) {
            return 3;
        }
        if ("ABOVE_BOTTOM".equals(pos)) {
            return 4;
        }
        if ("BOTTOM".equals(pos)) {
            return 5;
        }
        if ("BELOW_BOTTOM".equals(pos)) {
            return 6;
        }
        return 0;
    }

    public static int fromJustificationString(String just) {
        if ("LEFT".equals(just)) {
            return 1;
        }
        if ("CENTER".equals(just)) {
            return 2;
        }
        if ("RIGHT".equals(just)) {
            return 3;
        }
        if ("LEADING".equals(just)) {
            return 4;
        }
        if ("TRAILING".equals(just)) {
            return 5;
        }
        return 0;
    }

    public boolean isIncludeTitle() {
        return this.m_include_title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getJustification() {
        return this.m_justification;
    }

    public int getPosition() {
        return this.m_position;
    }

    public Color getTextColor() {
        return this.m_text_color.getColor();
    }

    public ColorProperty getTextColorProperty() {
        return this.m_text_color;
    }

    public Font getTextFont() {
        return UIManager.getFont("Table.font");
    }

    public boolean isTopPainted() {
        return this.m_top;
    }

    public boolean isLeftPainted() {
        return this.m_left;
    }

    public boolean isBottomPainted() {
        return this.m_bottom;
    }

    public boolean isRightPainted() {
        return this.m_right;
    }

    public void setIncludeTitle(boolean includeTitle) {
        this.m_include_title = includeTitle;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setJustification(int justification) {
        this.m_justification = justification;
    }

    public void setPosition(int position) {
        this.m_position = position;
    }

    public void setTextColorProperty(ColorProperty c) {
        this.m_text_color.setValue(c);
    }

    public void setTopPainted(boolean bpaint) {
        this.m_top = bpaint;
    }

    public void setLeftPainted(boolean bpaint) {
        this.m_left = bpaint;
    }

    public void setBottomPainted(boolean bpaint) {
        this.m_bottom = bpaint;
    }

    public void setRightPainted(boolean bpaint) {
        this.m_right = bpaint;
    }

    public void setValue(Object obj) {
        if (obj instanceof BorderProperty) {
            BorderProperty bp = (BorderProperty)obj;
            this.m_include_title = bp.m_include_title;
            this.m_title = bp.m_title;
            this.m_justification = bp.m_justification;
            this.m_position = bp.m_position;
            this.m_text_color = bp.m_text_color;
            this.m_top = bp.m_top;
            this.m_left = bp.m_left;
            this.m_bottom = bp.m_bottom;
            this.m_right = bp.m_right;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static String toPositionString(int pos) {
        switch (pos) {
            case 1: {
                return "ABOVE_TOP";
            }
            case 2: {
                return "TOP";
            }
            case 3: {
                return "BELOW_TOP";
            }
            case 4: {
                return "ABOVE_BOTTOM";
            }
            case 5: {
                return "BOTTOM";
            }
            case 6: {
                return "BELOW_BOTTOM";
            }
        }
        return "DEFAULT_POSITION";
    }

    public static String toJustificationString(int just) {
        switch (just) {
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "RIGHT";
            }
            case 4: {
                return "LEADING";
            }
            case 5: {
                return "TRAILING";
            }
        }
        return "DEFAULT_JUSTIFICATION";
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        if (version == 1) {
            this.m_title = (String)in.readObject("title");
        } else {
            this.m_include_title = in.readBoolean("includetitle", false);
            this.m_title = (String)in.readObject("title");
            this.m_justification = in.readInt("justification", 0);
            this.m_position = in.readInt("position", 0);
            Object col = in.readObject("textcolor");
            if (col instanceof Color) {
                this.m_text_color.setConstantColor((Color)col);
            } else if (col instanceof ColorProperty) {
                this.m_text_color = (ColorProperty)col;
            } else if (col != null) {
                System.out.println("BorderProperty: Unknown object:  " + col);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            if (this.m_text_color == null) {
                this.m_text_color = new ColorProperty("TitledBorder.titleColor");
            }
            if (version > 2) {
                this.m_top = in.readBoolean("top", true);
                this.m_left = in.readBoolean("left", true);
                this.m_bottom = in.readBoolean("bottom", true);
                this.m_right = in.readBoolean("right", true);
            }
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(4);
        out.writeBoolean("includetitle", this.m_include_title, false);
        out.writeObject("title", this.m_title);
        out.writeInt("justification", this.m_justification, 0);
        out.writeInt("position", this.m_position, 0);
        if (DEFAULT_TEXT_COLOR.equals(this.m_text_color)) {
            out.writeObject("textcolor", this.m_text_color);
        } else {
            out.writeObject("textcolor", null);
        }
        out.writeBoolean("top", this.m_top, true);
        out.writeBoolean("left", this.m_left, true);
        out.writeBoolean("bottom", this.m_bottom, true);
        out.writeBoolean("right", this.m_right, true);
    }

    public void updateBean(JETABean jbean) {
        Component comp = null;
        if (jbean != null) {
            comp = jbean.getDelegate();
        }
        if (comp instanceof JComponent) {
            ((JComponent)comp).setBorder(this.createBorder(comp));
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !BorderProperty.class.desiredAssertionStatus();
        DEFAULT_TEXT_COLOR = new ColorProperty("TitledBorder.titleColor");
    }
}

