/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.colormgr.ColorManager;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.open.registry.JETARegistry;
import java.awt.Color;
import java.io.IOException;

public class ColorProperty
extends JETAProperty {
    static final long serialVersionUID = -4907629297184715948L;
    public static final int VERSION = 2;
    public static final String CONSTANT_COLOR = "constant";
    public static final String DEFAULT_COLOR = "default";
    private Color m_constant_color = Color.black;
    private String m_color_key = "constant";
    private int m_brightness = 0;
    private float m_brightness_factor = 0.7f;
    public static final float DEFAULT_FACTOR = 0.7f;
    public static final int DEFAULT_BRIGHTNESS = 0;
    public static final String PROPERTY_ID = "dyncolor";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColorProperty() {
        super(PROPERTY_ID);
    }

    public ColorProperty(Color c) {
        super(PROPERTY_ID);
        this.m_constant_color = c;
        this.m_color_key = CONSTANT_COLOR;
    }

    public ColorProperty(String colorKey) {
        super(PROPERTY_ID);
        this.m_color_key = colorKey;
        if (!$assertionsDisabled && CONSTANT_COLOR.equals(colorKey)) {
            throw new AssertionError();
        }
    }

    private Color brighter(Color c, float factor) {
        if ((double)factor < 0.01) {
            factor = 0.01f;
        } else if ((double)factor > 1.0) {
            factor = 1.0f;
        }
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (red == 0 && green == 0 && blue == 0) {
            return new Color(i, i, i);
        }
        if (red > 0 && red < i) {
            red = i;
        }
        if (green > 0 && green < i) {
            green = i;
        }
        if (blue > 0 && blue < i) {
            blue = i;
        }
        return new Color(Math.min((int)((float)red / factor), 255), Math.min((int)((float)green / factor), 255), Math.min((int)((float)blue / factor), 255));
    }

    public Color darker(Color c, float factor) {
        return new Color(Math.max((int)((float)c.getRed() * factor), 0), Math.max((int)((float)c.getGreen() * factor), 0), Math.max((int)((float)c.getBlue() * factor), 0));
    }

    public boolean equals(Object object) {
        if (object instanceof ColorProperty) {
            ColorProperty cp = (ColorProperty)object;
            return super.equals(object) && ColorProperty.isEqual(this.m_constant_color, cp.m_constant_color) && ColorProperty.isEqual(this.m_color_key, cp.m_color_key) && this.m_brightness == cp.m_brightness && this.m_brightness_factor == cp.m_brightness_factor;
        }
        return false;
    }

    public Color getColor() {
        Color result = Color.white;
        if (this.isConstant()) {
            result = this.m_constant_color;
        } else {
            ColorManager cmgr = (ColorManager)JETARegistry.lookup("jeta.color.manager");
            if (cmgr != null) {
                result = cmgr.getColor(this.m_color_key, null);
            }
        }
        if (result == null) {
            result = Color.white;
        }
        result = this.modifyBrightness(result);
        return result;
    }

    public int getBrightness() {
        return this.m_brightness;
    }

    public float getBrightnessFactor() {
        return this.m_brightness_factor;
    }

    public String getColorKey() {
        return this.m_color_key;
    }

    public Color getConstantColor() {
        return this.m_constant_color;
    }

    private Color modifyBrightness(Color result) {
        for (int count = 0; count < Math.abs(this.m_brightness); ++count) {
            if (this.m_brightness > 0) {
                result = this.brighter(result, this.m_brightness_factor);
                continue;
            }
            if (this.m_brightness >= 0) continue;
            result = this.darker(result, this.m_brightness_factor);
        }
        return result;
    }

    public void setBrightness(int ival) {
        this.m_brightness = ival;
    }

    public void setBrightnessFactor(float fval) {
        this.m_brightness_factor = fval;
    }

    public void setColorKey(String color_key) {
        this.m_color_key = color_key;
    }

    public boolean isConstant() {
        return CONSTANT_COLOR.equalsIgnoreCase(this.m_color_key);
    }

    public void setConstantColor(Color c) {
        this.m_constant_color = c;
        this.m_color_key = CONSTANT_COLOR;
    }

    public void setValue(Object prop) {
        if (prop instanceof ColorProperty) {
            ColorProperty cprop = (ColorProperty)prop;
            this.m_color_key = cprop.m_color_key;
            this.m_constant_color = cprop.m_constant_color;
            this.m_brightness = cprop.m_brightness;
            this.m_brightness_factor = cprop.m_brightness_factor;
        } else if (prop != null && !$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_color_key = (String)in.readObject("colorkey");
        Object color = in.readObject("constantcolor");
        if (color instanceof Color) {
            this.m_constant_color = (Color)color;
        } else if (color instanceof ColorHolder) {
            this.m_constant_color = ((ColorHolder)color).getColor();
        }
        if (version > 1) {
            this.m_brightness = in.readInt("brightness", 0);
            this.m_brightness_factor = in.readFloat("brightnessfactor", 0.7f);
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(2);
        out.writeObject("colorkey", this.m_color_key);
        if (this.isConstant()) {
            out.writeObject("constantcolor", new ColorHolder(this.m_constant_color));
        } else {
            out.writeObject("constantcolor", null);
        }
        out.writeInt("brightness", this.m_brightness, 0);
        out.writeFloat("brightnessfactor", this.m_brightness_factor, 0.7f);
    }

    static {
        $assertionsDisabled = !ColorProperty.class.desiredAssertionStatus();
    }
}

