/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.LineProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class CompoundLineProperty
extends JETAProperty {
    static final long serialVersionUID = 8321803759018530163L;
    public static final int VERSION = 2;
    private LinkedList m_lines = new LinkedList();
    private int m_position;
    public static final String PROPERTY_ID = "lineDefinition";

    public CompoundLineProperty() {
        super(PROPERTY_ID);
    }

    public CompoundLineProperty(LineProperty lp) {
        super(PROPERTY_ID);
        this.addLine(lp);
    }

    public Collection getLines() {
        return this.m_lines;
    }

    public void addLine(LineProperty lp) {
        if (lp != null) {
            this.m_lines.addLast(lp);
        }
    }

    public int getPosition() {
        return this.m_position;
    }

    public Iterator iterator() {
        return this.m_lines.iterator();
    }

    public void print() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            LineProperty prop = (LineProperty)iter.next();
            prop.print();
        }
    }

    public void setLines(Collection lines) {
        this.m_lines.clear();
        this.m_lines.addAll(lines);
    }

    public void setPosition(int pos) {
        this.m_position = pos;
    }

    public void setValue(Object prop) {
        if (prop instanceof CompoundLineProperty) {
            CompoundLineProperty cb = (CompoundLineProperty)prop;
            this.m_lines.clear();
            this.m_lines.addAll(cb.m_lines);
            this.m_position = cb.m_position;
        }
    }

    public void updateBean(JETABean jbean) {
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_lines = (LinkedList)in.readObject("lines");
        if (version > 1) {
            this.m_position = in.readInt("position");
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(2);
        out.writeObject("lines", this.m_lines);
        out.writeInt("position", this.m_position);
    }
}

