/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.util;

import com.mxgraph.swing.util.mxICellOverlay;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import java.awt.Cursor;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class mxCellOverlay
extends JComponent
implements mxICellOverlay {
    private static final long serialVersionUID = 921991820491141221L;
    protected ImageIcon imageIcon;
    protected Object align = "right";
    protected Object verticalAlign = "bottom";
    protected double defaultOverlap = 0.5;

    public mxCellOverlay(ImageIcon icon, String warning) {
        this.imageIcon = icon;
        this.setToolTipText(warning);
        this.setCursor(new Cursor(0));
    }

    public Object getAlign() {
        return this.align;
    }

    public void setAlign(Object value) {
        this.align = value;
    }

    public Object getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(Object value) {
        this.verticalAlign = value;
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.imageIcon.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
    }

    @Override
    public mxRectangle getBounds(mxCellState state) {
        boolean isEdge = state.getView().getGraph().getModel().isEdge(state.getCell());
        double s = state.getView().getScale();
        mxPoint pt = null;
        int w = this.imageIcon.getIconWidth();
        int h = this.imageIcon.getIconHeight();
        if (isEdge) {
            int n = state.getAbsolutePointCount();
            if (n % 2 == 1) {
                pt = state.getAbsolutePoint(n / 2 + 1);
            } else {
                int idx = n / 2;
                mxPoint p0 = state.getAbsolutePoint(idx - 1);
                mxPoint p1 = state.getAbsolutePoint(idx);
                pt = new mxPoint(p0.getX() + (p1.getX() - p0.getX()) / 2.0, p0.getY() + (p1.getY() - p0.getY()) / 2.0);
            }
        } else {
            pt = new mxPoint();
            if (this.align.equals("left")) {
                pt.setX(state.getX());
            } else if (this.align.equals("center")) {
                pt.setX(state.getX() + state.getWidth() / 2.0);
            } else {
                pt.setX(state.getX() + state.getWidth());
            }
            if (this.verticalAlign.equals("top")) {
                pt.setY(state.getY());
            } else if (this.verticalAlign.equals("middle")) {
                pt.setY(state.getY() + state.getHeight() / 2.0);
            } else {
                pt.setY(state.getY() + state.getHeight());
            }
        }
        return new mxRectangle(pt.getX() - (double)w * this.defaultOverlap * s, pt.getY() - (double)h * this.defaultOverlap * s, (double)w * s, (double)h * s);
    }
}

