/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.info;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.PackageInfoReader;
import org.gvsig.installer.lib.spi.InstallerInfoFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallerInfoFileReader
implements PackageInfoReader {
    private static final Logger LOG = LoggerFactory.getLogger(InstallerInfoFileReader.class);

    public void read(PackageInfo installerInfoResource, String fileName) throws InstallerInfoFileException {
        this.read(installerInfoResource, new File(fileName));
    }

    public void read(PackageInfo installerInfoResource, File file) throws InstallerInfoFileException {
        if (!file.exists()) {
            throw new InstallerInfoFileException("install_infofile_not_found");
        }
        try {
            this.read(installerInfoResource, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new InstallerInfoFileException("install_infofile_not_found", (Throwable)e);
        }
    }

    public void read(PackageInfo installerInfoResource, InputStream is) throws InstallerInfoFileException {
        String sourcesUrlStr;
        String dependencies;
        String owner;
        String modelVersion;
        String jvm;
        String arch;
        String oldBuild;
        Properties properties = new Properties();
        try {
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new InstallerInfoFileException("install_infofile_reading_error", (Throwable)e);
        }
        installerInfoResource.setCode(properties.getProperty("code"));
        String codealias1 = properties.getProperty("code-alias");
        if (codealias1 != null) {
            String[] s = codealias1.split(",");
            for (int i = 0; i < s.length; ++i) {
                s[i] = s[i].trim();
                if ("".equals(s[i])) continue;
                installerInfoResource.getAllCodes().add(s[i]);
            }
        }
        String name = properties.getProperty("name");
        installerInfoResource.setName(name);
        installerInfoResource.setDescription(properties.getProperty("description"));
        String version = properties.getProperty("version");
        if (version == null) {
            LOG.warn("Got a null version string for the {} plugin Ignoring it and leaving the default version value", (Object)name);
        } else {
            installerInfoResource.setVersion(version);
        }
        installerInfoResource.setType(properties.getProperty("type"));
        String build = properties.getProperty("buildNumber");
        if (build != null && installerInfoResource.getVersion().getBuild() == 0) {
            try {
                installerInfoResource.setBuild(Integer.parseInt(build));
            }
            catch (Exception e) {
                installerInfoResource.setBuild(0);
                LOG.info("Error while converting to int the buildNumber property value: " + build, (Throwable)e);
            }
        }
        if (installerInfoResource.getBuild() <= 0 && (oldBuild = properties.getProperty("build")) != null) {
            try {
                installerInfoResource.setBuild(Integer.parseInt(oldBuild));
            }
            catch (Exception e) {
                installerInfoResource.setBuild(0);
                LOG.info("Error while converting to int the build property value: " + oldBuild, (Throwable)e);
            }
        }
        installerInfoResource.setState(properties.getProperty("state"));
        try {
            installerInfoResource.setOfficial(Boolean.parseBoolean(properties.getProperty("official")));
        }
        catch (Exception e) {
            installerInfoResource.setOfficial(false);
            LOG.info("Error while converting to boolean the official property value: " + properties.getProperty("official"), (Throwable)e);
        }
        String os = properties.getProperty("operating-system");
        if (os != null) {
            installerInfoResource.setOperatingSystem(os);
        }
        if ((arch = properties.getProperty("architecture")) != null) {
            installerInfoResource.setArchitecture(arch);
        }
        if ((jvm = properties.getProperty("java-version")) != null) {
            installerInfoResource.setJavaVM(jvm);
        }
        installerInfoResource.setGvSIGVersion(properties.getProperty("gvSIG-version"));
        String urlStr = properties.getProperty("download-url");
        if (urlStr != null) {
            installerInfoResource.setDownloadURL(urlStr);
        }
        if ((modelVersion = properties.getProperty("model-version")) != null) {
            installerInfoResource.setModelVersion(modelVersion);
        }
        if ((owner = properties.getProperty("owner")) != null) {
            installerInfoResource.setOwner(owner);
        }
        if ((dependencies = properties.getProperty("dependencies")) != null) {
            installerInfoResource.setDependencies(dependencies);
        }
        if ((sourcesUrlStr = properties.getProperty("sources-url")) != null && !sourcesUrlStr.equals("")) {
            URL sourcesURL;
            try {
                if (sourcesUrlStr.toLowerCase().startsWith("scm:svn:http")) {
                    sourcesUrlStr = sourcesUrlStr.substring(8);
                }
                sourcesURL = new URL(sourcesUrlStr);
            }
            catch (MalformedURLException e) {
                throw new InstallerInfoFileException("Error getting the value of the sources url property as URL: " + sourcesUrlStr, (Throwable)e);
            }
            installerInfoResource.setSourcesURL(sourcesURL);
        } else {
            installerInfoResource.setSourcesURL(null);
        }
        String webUrlStr = properties.getProperty("web-url");
        if (webUrlStr != null && !webUrlStr.equals("")) {
            URL webUrl;
            try {
                webUrl = new URL(webUrlStr);
            }
            catch (MalformedURLException e) {
                throw new InstallerInfoFileException("Error getting the value of the web url property as URL: " + webUrlStr, (Throwable)e);
            }
            installerInfoResource.setWebURL(webUrl);
        } else {
            installerInfoResource.setWebURL(null);
        }
        String ownerURLStr = properties.getProperty("owner-url");
        if (ownerURLStr != null && !ownerURLStr.equals("")) {
            URL ownerUrl;
            try {
                ownerUrl = new URL(ownerURLStr);
            }
            catch (MalformedURLException e) {
                throw new InstallerInfoFileException("Error getting the value of the owner url property as URL: " + ownerURLStr, (Throwable)e);
            }
            installerInfoResource.setOwnerURL(ownerUrl);
        } else {
            installerInfoResource.setOwnerURL(null);
        }
        String categories = properties.getProperty("categories");
        if (categories != null && !categories.equals("")) {
            installerInfoResource.addCategoriesAsString(categories);
        }
    }
}

