/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.util.MapBuilder;

public class InstanceUtils {
    private static Map<Class, Class> typeMapping = new MapBuilder().add(Character.class, Character.TYPE).add(Byte.class, Byte.TYPE).add(Short.class, Short.TYPE).add(Integer.class, Integer.TYPE).add(Long.class, Long.TYPE).add(Float.class, Float.TYPE).add(Double.class, Double.TYPE).add(Boolean.class, Boolean.TYPE).build();

    public static Object callmethod(Object instance, String methodName, Object[] args) throws Exception {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new NullPointerException("A method name was expected to invoke and a null was received");
        }
        if (instance == null) {
            throw new NullPointerException("An object pointer was expected to invoke method " + methodName + " and a null was received");
        }
        Class<?> theClass = instance.getClass();
        return InstanceUtils.callmethod(theClass, instance, methodName, args);
    }

    public static Object callmethod(Class theClass, String methodName, Object[] args) throws Exception {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new NullPointerException("A method name was expected to invoke and a null was received");
        }
        if (theClass == null) {
            throw new NullPointerException("An class pointer was expected to invoke method " + methodName + " and a null was received");
        }
        return InstanceUtils.callmethod(theClass, null, methodName, args);
    }

    private static Object callmethod(Class theClass, Object instance, String methodName, Object[] args) throws Exception {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new NullPointerException("A method name was expected to invoke and a null was received");
        }
        Method method = InstanceUtils.getMethod(theClass, methodName, InstanceUtils.createParameterTypesAccurate(args));
        if (method == null) {
            method = InstanceUtils.getMethod(theClass, methodName, InstanceUtils.createParameterTypesUseScalarTypes(args));
        }
        if (method == null) {
            method = InstanceUtils.getMethod(theClass, methodName, InstanceUtils.createParameterTypesFuzzy(theClass, methodName, args));
        }
        if (method == null) {
            method = InstanceUtils.getMethod(theClass, methodName, InstanceUtils.createParameterTypesAllObjects(args));
        }
        if (method == null) {
            method = InstanceUtils.getMethod(theClass, methodName, InstanceUtils.createParameterTypesFromMethodNameAndParametersCount(theClass, methodName, args));
        }
        method.setAccessible(true);
        Object value = method.invoke(instance, args);
        return value;
    }

    private static Method getMethod(Class theClass, String methodName, Class[] parameterTypes) {
        if (parameterTypes == null) {
            return null;
        }
        try {
            return theClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Class[] createParameterTypesAccurate(Object[] parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter;
            parameters[i] = parameter = parameters[i];
            parameterTypes[i] = parameter == null ? null : parameter.getClass();
        }
        return parameterTypes;
    }

    private static Class[] createParameterTypesUseScalarTypes(Object[] parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter;
            parameters[i] = parameter = parameters[i];
            if (parameter == null) {
                parameterTypes[i] = null;
                continue;
            }
            Class<?> paramClass = parameter.getClass();
            parameterTypes[i] = typeMapping.getOrDefault(paramClass, paramClass);
        }
        return parameterTypes;
    }

    private static Class[] createParameterTypesAllObjects(Object[] parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter;
            parameters[i] = parameter = parameters[i];
            parameterTypes[i] = parameter == null ? null : Object.class;
        }
        return parameterTypes;
    }

    private static Class[] createParameterTypesFromMethodNameAndParametersCount(Class theClass, String methodName, Object[] parameters) {
        for (Method m : theClass.getMethods()) {
            if (!StringUtils.equals((CharSequence)m.getName(), (CharSequence)methodName) || parameters.length != m.getParameterTypes().length) continue;
            return m.getParameterTypes();
        }
        return null;
    }

    private static Class[] createParameterTypesFuzzy(Class theClass, String methodName, Object[] parameters) {
        for (Method m : theClass.getMethods()) {
            if (!StringUtils.equals((CharSequence)m.getName(), (CharSequence)methodName) || parameters.length != m.getParameterTypes().length) continue;
            int n = 0;
            Class[] parameterTypes = new Class[parameters.length];
            for (Class<?> expectedType : m.getParameterTypes()) {
                if (parameters[n] == null) {
                    parameterTypes[n++] = Object.class;
                    continue;
                }
                Class<?> paramType = parameters[n].getClass();
                if (expectedType == paramType) {
                    parameterTypes[n++] = expectedType;
                    continue;
                }
                if (expectedType == Object.class) {
                    parameterTypes[n++] = Object.class;
                    continue;
                }
                parameterTypes = null;
                break;
            }
            if (parameterTypes == null) continue;
            return parameterTypes;
        }
        return null;
    }
}

