/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.image;

import java.io.File;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.programming.FileFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class ImageWriteFunction
extends AbstractFunction {
    public ImageWriteFunction() {
        super("Image", "IMAGEWRITE", Range.is((Comparable)Integer.valueOf(3)), "Read an image from a data source and return it as a 'Java BufferedImage' object.", "IMAGEWRITE({{simpleimage}}, target, format)", new String[]{"Image to write", "Value to save the image in", "Format name, PNG, JPEG,..."}, "SimpleImage", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        String formatName = this.getStr(args, 2);
        Object arg0 = this.getObject(args, 0);
        SimpleImage image = ToolsSwingLocator.getToolsSwingManager().createSimpleImage(arg0);
        Object target = this.getObject(args, 1);
        try {
            if (target instanceof OutputStream) {
                image.save((OutputStream)target, formatName);
            } else {
                File f = FileFunction.toFile(target);
                image.save(f, formatName);
            }
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Can't write image to '" + Objects.toString(target) + " as format '" + formatName + ".", (Throwable)ex);
        }
        return image;
    }
}

