/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class RoundFunction
extends AbstractFunction {
    public RoundFunction() {
        super("Numeric", "ROUND", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        double r;
        double value = this.getDouble(args, 0);
        if (args.length > 1) {
            int decimals = this.getInt(args, 1);
            r = MathUtils.round((double)value, (int)decimals);
        } else {
            r = Math.round(value);
        }
        return r;
    }
}

