/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class SignFunction
extends AbstractFunction {
    public SignFunction() {
        super("Numeric", "SIGN", Range.is((Comparable)Integer.valueOf(1)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object value = args[0];
        if (value instanceof Float) {
            float r = Math.signum(((Number)value).floatValue());
            return Float.valueOf(r);
        }
        double r = Math.signum(this.getDouble(args, 0));
        return r;
    }
}

