/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class ConcatOperator
extends AbstractBinaryOperator
implements Optimizer.FunctionOptimizer {
    public ConcatOperator() {
        super("String", "||", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return Objects.toString(op1, "") + Objects.toString(op2, "");
    }

    public Code optimize(Optimizer optimizer, Code.Callable caller) {
        Code op1 = optimizer.optimize((Code)caller.parameters().get(0));
        Code op2 = optimizer.optimize((Code)caller.parameters().get(1));
        if (op1.code() == 0 && op2.code() == 0) {
            Code.Constant newCode = optimizer.getCodeBuilder().constant(this.call(optimizer.getInterpreter(), ((Code.Constant)op1).value(), ((Code.Constant)op2).value()));
            return newCode;
        }
        if (op1.code() == 0) {
            String value = Objects.toString(((Code.Constant)op1).value(), "");
            if (StringUtils.isEmpty((CharSequence)value)) {
                return op2;
            }
            Code.Callable newCode = optimizer.getCodeBuilder().operator(caller.name(), op1, op2);
            return newCode;
        }
        if (op2.code() == 0) {
            String value = Objects.toString(((Code.Constant)op2).value(), "");
            if (StringUtils.isEmpty((CharSequence)value)) {
                return op1;
            }
            Code.Callable newCode = optimizer.getCodeBuilder().operator(caller.name(), op1, op2);
            return newCode;
        }
        return caller;
    }
}

