/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CRC32Function
extends AbstractFunction {
    public CRC32Function() {
        super("Programming", "CRC", Range.is((Comparable)Integer.valueOf(1)), null, "CRC32({{object}})", null, null, false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object obj = this.getObject(args, 0);
        CRC32 crc32 = new CRC32();
        if (obj instanceof byte[]) {
            crc32.update((byte[])obj);
        } else if (obj instanceof CharSequence) {
            crc32.update(obj.toString().getBytes(StandardCharsets.UTF_8));
        } else if (obj instanceof Integer) {
            crc32.update((Integer)obj);
        } else if (obj instanceof ByteBuffer) {
            crc32.update((ByteBuffer)obj);
        } else if (obj instanceof InputStream) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)((InputStream)obj), (OutputStream)out);
            crc32.update(out.toByteArray());
        } else if (obj instanceof Serializable) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(out);){
                oos.writeObject(obj);
            }
            crc32.update(out.toByteArray());
        } else {
            throw new IllegalArgumentException("type not supported");
        }
        return crc32.getValue();
    }
}

