/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.script.Script;

public class ImportFunction
extends AbstractFunction {
    public static final String FUNCTION_IMPORT = "IMPORT";

    public ImportFunction() {
        super("Programming", FUNCTION_IMPORT, Range.is((Comparable)Integer.valueOf(1)), "Import a module from the current resources storage", "IMPORT {{module}}", new String[]{"module - Module name to import"}, "Script", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String name = this.getStr(args, 0);
        if (name == null) {
            throw new NullPointerException("A string with a module name was expected and a null was received");
        }
        SymbolTable symbolTable = interpreter.getSymbolTable();
        if (symbolTable instanceof MutableSymbolTable) {
            ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
            Script module = expressionManager.loadScript(interpreter.getResourcesStorage(), name);
            if (module == null) {
                return null;
            }
            ((MutableSymbolTable)symbolTable).setVar(name, (Object)module);
            return module;
        }
        return null;
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        builder.append("IMPORT ");
        builder.append(((Code)args.get(0)).toString(formatter));
        return builder.toString();
    }
}

