/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Iterator;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class RangeFunction
extends AbstractFunction {
    public RangeFunction() {
        super("Programming", "RANGE", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), "", "RANGE({{start}}, stop, step)", null, "Iterable", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, final Object[] args) throws Exception {
        switch (args.length) {
            case 1: {
                return new Iterable<Long>(){

                    @Override
                    public Iterator<Long> iterator() {
                        return new XRangeIterator(0L, RangeFunction.this.getLong(args, 0), 1L);
                    }
                };
            }
            case 2: {
                return new Iterable<Long>(){

                    @Override
                    public Iterator<Long> iterator() {
                        return new XRangeIterator(RangeFunction.this.getLong(args, 0), RangeFunction.this.getLong(args, 1), 1L);
                    }
                };
            }
            case 3: {
                return new Iterable<Long>(){

                    @Override
                    public Iterator<Long> iterator() {
                        return new XRangeIterator(RangeFunction.this.getLong(args, 0), RangeFunction.this.getLong(args, 1), RangeFunction.this.getLong(args, 2));
                    }
                };
            }
        }
        throw new ExpressionRuntimeException("Incorrect number of arguments in function range.");
    }

    private static class XRangeIterator
    implements Iterator<Long> {
        private final long start;
        private final long stop;
        private final long step;
        private long current;

        public XRangeIterator(long start, long stop, long step) {
            this.start = start;
            this.stop = stop;
            this.step = step;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.stop;
        }

        @Override
        public Long next() {
            long n = this.current;
            this.current += this.step;
            return n;
        }
    }
}

