/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class VarFunction
extends AbstractFunction {
    public static final String NAME = "VAR";

    public VarFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), "Declare a variable.\nExample:\n  VAR x DEFAULT 0\n", "VAR {{identifier}} DEFAULT default_value", new String[]{"identifier_name - Name of the variable", "default_value - Value to assign to the variable if have to create it."}, "NULL", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        return null;
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        SymbolTable symbolTable;
        Code varNameCode = (Code)args.get(0);
        if (varNameCode.code() != 1) {
            throw new RuntimeException("First argument must be a identifier.");
        }
        String name = ((Code.Identifier)varNameCode).name();
        Object value = null;
        if (args.size() == 2) {
            value = interpreter.run((Code)args.get(1));
        }
        if ((symbolTable = interpreter.getSymbolTable()) instanceof MutableSymbolTable) {
            if (symbolTable.exists(name)) {
                value = symbolTable.value(name);
            } else {
                ((MutableSymbolTable)symbolTable).setVar(name, value);
            }
        } else {
            throw new RuntimeException("A MutableSymbolTable is required for use VAR function.");
        }
        return value;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        builder.append("VAR \"");
        builder.append(Objects.toString(((Code.Identifier)args.get(0)).name()));
        builder.append("\" DEFAULT ");
        builder.append(((Code)args.get(1)).toString(formatter));
        return builder.toString();
    }
}

