/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.repr;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ReprMethod;

public class ReprLocalDateTime
implements ReprMethod {
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isApplicable(Object value) {
        return value instanceof LocalDateTime;
    }

    public String repr(Object value) {
        if (value == null) {
            return "NULL";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDate = ((LocalDateTime)value).format(dateTimeFormatter);
        return "TIMESTAMP '" + formattedDate + "'";
    }

    public static void selfRegister() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        manager.addReprMethod((ReprMethod)new ReprLocalDateTime());
    }
}

