/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import org.gvsig.installer.swing.impl.creation.model.SelectFilesTreeCellRenderer;
import org.gvsig.installer.swing.impl.creation.model.SelectFilesTreeCheckNode;
import org.gvsig.installer.swing.impl.creation.model.SelectFilesTreeModel;
import org.gvsig.installer.swing.impl.creation.model.SelectFilesTreeNodeSelectionListener;

public class SelectFilesTree
extends JTree {
    private static final long serialVersionUID = 9167217334192981460L;

    public void setApplicationDirectory(File applicationDirectory) {
        this.setModel(new SelectFilesTreeModel(applicationDirectory));
        this.setCellRenderer(new SelectFilesTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new SelectFilesTreeNodeSelectionListener(this));
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> selectedFiles = new ArrayList<File>();
        this.addSelectedFiles((SelectFilesTreeCheckNode)this.getModel().getRoot(), selectedFiles);
        return selectedFiles;
    }

    public void addSelectedFiles(SelectFilesTreeCheckNode node, List<File> selectedFiles) {
        if (node.isSelected) {
            File absolutePath = new File(node.getFile().getAbsolutePath());
            if (!absolutePath.isDirectory()) {
                selectedFiles.add(absolutePath);
            } else {
                this.traverseChildren(node, selectedFiles);
            }
        } else if (node.getFile().isDirectory()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.addSelectedFiles((SelectFilesTreeCheckNode)node.getChildAt(i), selectedFiles);
            }
            this.traverseChildren(node, selectedFiles);
        }
    }

    protected void traverseChildren(SelectFilesTreeCheckNode node, List<File> selectedFiles) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addSelectedFiles((SelectFilesTreeCheckNode)node.getChildAt(i), selectedFiles);
        }
    }
}

