/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.wizard;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.impl.creation.DefaultMakePluginPackageWizard;
import org.gvsig.installer.swing.impl.creation.panel.AdvancedModeSelectionPanel;

public class AdvancedModeSelectionWizard
extends AdvancedModeSelectionPanel
implements OptionPanel {
    private static final long serialVersionUID = 257540289911849694L;
    private DefaultMakePluginPackageWizard installerCreationWizard;

    public AdvancedModeSelectionWizard(DefaultMakePluginPackageWizard installerCreationWizard) {
        this.installerCreationWizard = installerCreationWizard;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.swingInstallerManager.getText("_advanced_options");
    }

    public void lastPanel() {
    }

    public void nextPanel() {
        if (!this.isAdvancedModeSelected()) {
            PackageInfo packageInfo;
            boolean success;
            String msg;
            int resp;
            InstallerManager manager = InstallerLocator.getInstallerManager();
            String pluginName = this.installerCreationWizard.getSelectedPackageInfo().getCode();
            File pluginLocation = manager.getAddonFolder(pluginName);
            File folder = null;
            if (pluginLocation != null) {
                String path = pluginLocation.getAbsolutePath() + File.separator + "install";
                folder = new File(path);
            }
            if (folder != null && folder.exists() && (resp = JOptionPane.showConfirmDialog(null, msg = Messages.getText((String)"_the_folder_install_already_exists._do_you_want_to_delete_it_before_proceeding?"), Messages.getText((String)"_select_an_option"), 0)) == 0 && !(success = (packageInfo = this.installerCreationWizard.getSelectedPackageInfo()).removeInstallFolder(folder))) {
                JOptionPane.showMessageDialog(null, Messages.getText((String)"_Couldn't_delete_the_directory"));
            }
        }
        this.installerCreationWizard.setAdvancedModeSelected(this.isAdvancedModeSelected());
    }

    public void updatePanel() {
        PackageInfo pkg = this.installerCreationWizard.getSelectedPackageInfo();
        if (pkg.getType().equalsIgnoreCase("plugin")) {
            this.setAvancedModeSupported(true);
        } else {
            this.setAvancedModeSupported(false);
        }
    }
}

