/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.impl.execution.panel.PackagesTablePanel;
import org.gvsig.installer.swing.impl.execution.panel.filters.NameDescriptionOrCodeFilter;

public class FastFilterButtonsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 3767011079359743742L;
    private PackagesTablePanel panel;
    private SwingInstallerManager swingInstallerManager;
    private JButton searchButton;
    private JButton resetButton;
    private JTextField textField;
    private NameDescriptionOrCodeFilter filter = null;

    public FastFilterButtonsPanel(PackagesTablePanel panel) {
        this.panel = panel;
        this.swingInstallerManager = SwingInstallerLocator.getSwingInstallerManager();
        this.initComponents();
    }

    private void initComponents() {
        this.filter = new NameDescriptionOrCodeFilter("");
        JLabel fastFilterLabel = new JLabel(this.swingInstallerManager.getText("_fast_filter"));
        this.textField = new JTextField(20);
        MyKeyListener l = new MyKeyListener();
        this.textField.addKeyListener(l);
        this.searchButton = new JButton(this.swingInstallerManager.getText("_search"));
        this.searchButton.setActionCommand("search");
        this.searchButton.addActionListener(this);
        this.resetButton = new JButton(this.swingInstallerManager.getText("_reset_filters"));
        this.resetButton.setActionCommand("reset");
        this.resetButton.addActionListener(this);
        this.setLayout(new FlowLayout(0, 10, 10));
        this.add(fastFilterLabel);
        this.add(this.textField);
        this.add(this.resetButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("search".equals(e.getActionCommand())) {
            this.searchAction();
        } else if ("reset".equals(e.getActionCommand())) {
            this.resetAction();
        }
    }

    private void searchAction() {
        this.filter.setFilter(this.textField.getText());
        this.panel.setFilter(this.filter);
    }

    private void resetAction() {
        this.resetPanel();
    }

    public void resetPanel() {
        this.textField.setText("");
        this.filter.setFilter("");
        this.panel.setFilter(this.filter);
        this.panel.resetPanel();
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            FastFilterButtonsPanel.this.searchAction();
            FastFilterButtonsPanel.this.textField.requestFocus();
            FastFilterButtonsPanel.this.textField.setCaretPosition(FastFilterButtonsPanel.this.textField.getDocument().getLength());
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

