/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.execution.PackageFilter;
import org.gvsig.installer.swing.impl.execution.panel.filters.NameDescriptionOrCodeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -454014676003979512L;
    private Logger logger = LoggerFactory.getLogger(PackagesTableModel.class);
    private TablePackageInfo[] currentlyVisiblePackages = null;
    private final String[] columnNames;
    private InstallerManager installerManager = InstallerLocator.getInstallerManager();
    private InstallPackageService installerExecutionService;
    boolean isOfficial;
    private NameDescriptionOrCodeFilter packageFastFilter = null;
    private PackageFilter packageFilter = null;
    private Set<PackageInfo> selectedPackages = new HashSet<PackageInfo>();
    private Map<String, TablePackageInfo> allPackages = null;

    public PackagesTableModel(SwingInstallerManager swingInstallerManager, InstallPackageService installerExecutionService, boolean isOfficial) {
        this.installerExecutionService = installerExecutionService;
        this.isOfficial = isOfficial;
        Map<String, TablePackageInfo> infos = this.getDefaultPackages();
        this.currentlyVisiblePackages = infos.values().toArray(new TablePackageInfo[infos.size()]);
        this.sortInstallerInfos();
        this.columnNames = new String[]{"", "", "", swingInstallerManager.getText("_name"), swingInstallerManager.getText("_version"), swingInstallerManager.getText("_type")};
    }

    private void sortInstallerInfos() {
        Arrays.sort(this.currentlyVisiblePackages, new Comparator<TablePackageInfo>(){

            @Override
            public int compare(TablePackageInfo o1, TablePackageInfo o2) {
                PackageInfo p1 = o1.getPackageInfo();
                PackageInfo p2 = o2.getPackageInfo();
                String s1 = p1.getName() + "/" + p1.getVersion().fullFormat() + "/" + p1.getOperatingSystem() + "/" + p1.getArchitecture();
                String s2 = p2.getName() + "/" + p2.getVersion().fullFormat() + "/" + p2.getOperatingSystem() + "/" + p2.getArchitecture();
                return s1.compareToIgnoreCase(s2);
            }
        });
    }

    private boolean canSetAsDefault(List<String> defaultIDs, PackageInfo pkg) {
        String system_osfamily = this.installerManager.getOperatingSystemFamily();
        String system_arch = this.installerManager.getArchitecture();
        String pkg_os = pkg.getOperatingSystem();
        String pkg_arch = pkg.getArchitecture();
        if (defaultIDs != null) {
            for (int j = 0; j < defaultIDs.size(); ++j) {
                String code = defaultIDs.get(j);
                if (!pkg.matchID(code) || !pkg.getOperatingSystemFamily().equals(system_osfamily) && !pkg_os.equals("all")) continue;
                if ("all".equalsIgnoreCase(pkg_arch)) {
                    return true;
                }
                if (!system_arch.equalsIgnoreCase(pkg_arch)) continue;
                return true;
            }
        }
        this.logger.info("package '" + pkg.getCode() + "/" + pkg_os + "/" + pkg_arch + "' don't install as default.");
        return false;
    }

    private Map<String, TablePackageInfo> getDefaultPackages() {
        if (this.allPackages == null) {
            TablePackageInfo info;
            List defaultIDs = this.installerExecutionService.getDefaultSelectedPackagesIDs();
            this.allPackages = new HashMap<String, TablePackageInfo>();
            for (int i = 0; i < this.installerExecutionService.getPackageCount(); ++i) {
                PackageInfo installerInfo = this.installerExecutionService.getPackageInfo(i);
                info = new TablePackageInfo(installerInfo, false, true);
                PackageInfo pkg = info.getPackageInfo();
                if (this.canSetAsDefault(defaultIDs, pkg)) {
                    info.setDefault(true);
                }
                this.allPackages.put(info.getID(), info);
            }
            try {
                PackageInfo[] installedPackages = this.installerManager.getInstalledPackages();
                for (int i = 0; i < installedPackages.length; ++i) {
                    info = new TablePackageInfo(installedPackages[i], true, false);
                    TablePackageInfo x = this.allPackages.get(info.getID());
                    if (x == null) {
                        this.allPackages.put(info.getID(), info);
                        continue;
                    }
                    x.setInstalled(true);
                }
            }
            catch (MakePluginPackageServiceException e) {
                throw new RuntimeException(e);
            }
            TablePackageInfo tpi = null;
            String os = null;
            List idList = this.installerExecutionService.getDefaultSelectedPackagesIDs();
            if (idList != null) {
                for (int i = 0; i < idList.size(); ++i) {
                    tpi = this.getMatch((String)idList.get(i), this.allPackages);
                    if (tpi == null || !(os = tpi.getPackageInfo().getOperatingSystem()).equals(this.installerManager.getOperatingSystem()) && !os.equals("all")) continue;
                    tpi.setDefault(true);
                }
            }
        }
        return this.allPackages;
    }

    private TablePackageInfo getMatch(String id, Map<String, TablePackageInfo> map) {
        Iterator<TablePackageInfo> iter = map.values().iterator();
        TablePackageInfo item = null;
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.getPackageInfo().matchID(id)) continue;
            return item;
        }
        return null;
    }

    private Map<String, TablePackageInfo> getFilteredPackages(Map<String, TablePackageInfo> packageInfos) {
        HashMap<String, TablePackageInfo> infos = new HashMap<String, TablePackageInfo>();
        TablePackageInfo[] packs = packageInfos.values().toArray(new TablePackageInfo[infos.size()]);
        for (int i = 0; i < packs.length; ++i) {
            PackageInfo installerInfo = packs[i].getPackageInfo();
            if (!this.packageFilter.match(installerInfo)) continue;
            TablePackageInfo info = packs[i];
            infos.put(installerInfo.getID(), info);
        }
        return infos;
    }

    private Map<String, TablePackageInfo> getFastFilteredPackages(Map<String, TablePackageInfo> packageInfos) {
        HashMap<String, TablePackageInfo> infos = new HashMap<String, TablePackageInfo>();
        TablePackageInfo[] packs = packageInfos.values().toArray(new TablePackageInfo[infos.size()]);
        for (int i = 0; i < packs.length; ++i) {
            PackageInfo installerInfo = packs[i].getPackageInfo();
            if (!this.packageFastFilter.match(installerInfo)) continue;
            TablePackageInfo info = packs[i];
            infos.put(installerInfo.getID(), info);
        }
        return infos;
    }

    public void updatePackages() {
        Map<String, TablePackageInfo> infos = this.getDefaultPackages();
        if (this.isPackageFilterSet().booleanValue()) {
            infos = this.getFilteredPackages(infos);
        }
        if (this.isFastFilterSet().booleanValue()) {
            infos = this.getFastFilteredPackages(infos);
        }
        this.currentlyVisiblePackages = infos.values().toArray(new TablePackageInfo[infos.size()]);
        this.sortInstallerInfos();
    }

    public void selectDefaultPackages() {
        Iterator<String> iter = this.allPackages.keySet().iterator();
        TablePackageInfo tpi = null;
        while (iter.hasNext()) {
            tpi = this.allPackages.get(iter.next());
            if (!tpi.isDefault()) continue;
            tpi.setSelected(true);
        }
    }

    public void selectPackage(PackageInfo pkg) {
        Iterator<String> iter = this.allPackages.keySet().iterator();
        TablePackageInfo tpi = null;
        while (iter.hasNext()) {
            tpi = this.allPackages.get(iter.next());
            if (!pkg.equals(tpi.getPackageInfo())) continue;
            tpi.setSelected(true);
            return;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return PackageStatus.class;
            }
            case 1: {
                return PackageOfficialRecommended.class;
            }
            case 2: {
                return PackageOsAndArchitecture.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex >= this.columnNames.length ? "" : this.columnNames[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.currentlyVisiblePackages.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TablePackageInfo tableInfo = this.currentlyVisiblePackages[rowIndex];
        PackageInfo installerInfo = tableInfo.getPackageInfo();
        switch (columnIndex) {
            case 0: {
                PackageStatus installStatus = this.checkStatus(rowIndex);
                return installStatus;
            }
            case 1: {
                PackageOfficialRecommended officialRecommended = this.checkOfficialRecommended(rowIndex);
                return officialRecommended;
            }
            case 2: {
                PackageOsAndArchitecture packageSystem = this.checkPackageSystem(rowIndex);
                return packageSystem;
            }
            case 3: {
                return installerInfo.getName();
            }
            case 4: {
                return installerInfo.getVersion();
            }
            case 5: {
                return installerInfo.getType();
            }
        }
        return "";
    }

    private PackageOsAndArchitecture checkPackageSystem(int rowIndex) {
        PackageOsAndArchitecture oSArch = new PackageOsAndArchitecture();
        TablePackageInfo tableInfo = this.currentlyVisiblePackages[rowIndex];
        PackageInfo installerInfo = tableInfo.getPackageInfo();
        oSArch.osfamily = installerInfo.getOperatingSystemFamily();
        oSArch.osname = installerInfo.getOperatingSystemName();
        oSArch.osversion = installerInfo.getOperatingSystemVersion();
        oSArch.arch = installerInfo.getArchitecture();
        return oSArch;
    }

    private PackageStatus checkStatus(int rowIndex) {
        TablePackageInfo tableInfo = this.currentlyVisiblePackages[rowIndex];
        if (tableInfo.getPackageInfo().isBroken()) {
            return PackageStatus.BROKEN;
        }
        if (!this.installerManager.hasProviderToThisPackage(tableInfo.getPackageInfo())) {
            return PackageStatus.INSTALLATION_NOT_AVAILABLE;
        }
        if (tableInfo.isInstalled()) {
            if (tableInfo.isInstallable()) {
                if (tableInfo.isSelected()) {
                    return PackageStatus.TO_REINSTALL;
                }
                return PackageStatus.INSTALLED;
            }
            return PackageStatus.INSTALLED_NOT_INSTALLABLE;
        }
        if (tableInfo.isSelected()) {
            return PackageStatus.TO_INSTALL;
        }
        return PackageStatus.NOT_INSTALLED;
    }

    private PackageOfficialRecommended checkOfficialRecommended(int rowIndex) {
        TablePackageInfo tableInfo = this.currentlyVisiblePackages[rowIndex];
        PackageInfo packageInfo = tableInfo.getPackageInfo();
        if (packageInfo.isOfficial()) {
            if (this.currentlyVisiblePackages[rowIndex].isDefault()) {
                return PackageOfficialRecommended.OFFICIAL_RECOMMENDED;
            }
            return PackageOfficialRecommended.OFFICIAL_NOT_RECOMMENDED;
        }
        if (this.currentlyVisiblePackages[rowIndex].isDefault()) {
            return PackageOfficialRecommended.COMMUNITY_RECOMMENDED;
        }
        return PackageOfficialRecommended.COMMUNITY_NOT_RECOMMENDED;
    }

    public PackageInfo getPackageInfoAt(int rowIndex) {
        return this.currentlyVisiblePackages[rowIndex].getPackageInfo();
    }

    public String getDescriptionAt(int rowIndex) {
        return this.getPackageInfoAt(rowIndex).getDescription();
    }

    public URL getSourcesAt(int rowIndex) {
        return this.getPackageInfoAt(rowIndex).getSourcesURL();
    }

    public URL getOwnerUrlAt(int rowIndex) {
        return this.getPackageInfoAt(rowIndex).getOwnerURL();
    }

    public String getOwnerAt(int rowIndex) {
        return this.getPackageInfoAt(rowIndex).getOwner();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 && this.currentlyVisiblePackages[rowIndex].isInstallable();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            PackageStatus status = (PackageStatus)((Object)aValue);
            TablePackageInfo tableInfo = this.currentlyVisiblePackages[rowIndex];
            switch (status) {
                case INSTALLED: 
                case NOT_INSTALLED: {
                    tableInfo.setSelected(false);
                    break;
                }
                case TO_REINSTALL: 
                case TO_INSTALL: {
                    tableInfo.setSelected(true);
                }
            }
        }
    }

    public List<PackageInfo> getPackagesToInstall() {
        ArrayList<PackageInfo> packageInfosToInstall = new ArrayList<PackageInfo>();
        packageInfosToInstall.addAll(this.selectedPackages);
        return packageInfosToInstall;
    }

    public boolean hasAnyPackageSelected() {
        return this.selectedPackages.size() > 0;
    }

    public TablePackageInfo getPackageInfo(int row) {
        return this.currentlyVisiblePackages[row];
    }

    public void setFilter(PackageFilter filter) {
        this.packageFilter = filter;
    }

    public void setFilter(NameDescriptionOrCodeFilter filter) {
        this.packageFastFilter = filter;
    }

    private Boolean isFastFilterSet() {
        return this.packageFastFilter != null;
    }

    private Boolean isPackageFilterSet() {
        return this.packageFilter != null;
    }

    public PackageFilter getFilter() {
        return this.packageFastFilter;
    }

    public InstallPackageService getInstallPackageService() {
        return this.installerExecutionService;
    }

    public final class TablePackageInfo {
        private final PackageInfo packageInfo;
        private boolean isInstalled;
        private final boolean isInstallable;
        private boolean isDefault;

        public TablePackageInfo(PackageInfo packageInfo, boolean isInstalled, boolean isInstallable) {
            this(packageInfo, isInstalled, isInstallable, false);
        }

        public void setInstalled(boolean installed) {
            this.isInstalled = installed;
        }

        public TablePackageInfo(PackageInfo packageInfo, boolean isInstalled, boolean isInstallable, boolean isDefault) {
            this.packageInfo = packageInfo;
            this.isInstalled = isInstalled;
            this.isInstallable = isInstallable;
            this.isDefault = isDefault;
        }

        public String getID() {
            PackageInfo pkg = this.getPackageInfo();
            return pkg.getID();
        }

        public PackageInfo getPackageInfo() {
            return this.packageInfo;
        }

        public boolean isInstalled() {
            return this.isInstalled;
        }

        public boolean isInstallable() {
            return this.isInstallable;
        }

        public boolean isSelected() {
            return PackagesTableModel.this.selectedPackages.contains(this.packageInfo);
        }

        public void setSelected(boolean isSelected) {
            if (isSelected) {
                PackagesTableModel.this.selectedPackages.add(this.packageInfo);
            } else {
                PackagesTableModel.this.selectedPackages.remove(this.packageInfo);
            }
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }

    public class PackageOsAndArchitecture {
        public String osfamily;
        public String osname;
        public String osversion;
        public String arch;

        public String getOperatingSystemId() {
            if (StringUtils.isEmpty((CharSequence)this.osname)) {
                return this.osfamily;
            }
            return this.osfamily + "-" + this.osname;
        }
    }

    public static enum PackageOfficialRecommended {
        OFFICIAL_NOT_RECOMMENDED,
        OFFICIAL_RECOMMENDED,
        COMMUNITY_RECOMMENDED,
        COMMUNITY_NOT_RECOMMENDED;

    }

    public static enum PackageStatus {
        INSTALLED,
        NOT_INSTALLED,
        TO_REINSTALL,
        TO_INSTALL,
        INSTALLED_NOT_INSTALLABLE,
        BROKEN,
        INSTALLATION_NOT_AVAILABLE;

    }
}

