/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.packagebuilder.options;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.creation.JPackageInfoPanel;
import org.gvsig.installer.swing.impl.packagebuilder.BasePackageWizard;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.packageutils.PackageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageInfoOption
implements OptionPanel {
    private static final Logger logger = LoggerFactory.getLogger(PackageInfoOption.class);
    private final JPackageInfoPanel packageInfoPanel;
    private final BasePackageWizard wizard;

    public PackageInfoOption(BasePackageWizard wizard) {
        this.wizard = wizard;
        SwingInstallerManager installerManager = SwingInstallerLocator.getSwingInstallerManager();
        this.packageInfoPanel = installerManager.createPackageInfoPanel(wizard.getPackageType());
    }

    private String getText(String msg) {
        return Messages.getText((String)msg);
    }

    public JPanel getJPanel() {
        return this.packageInfoPanel;
    }

    public String getPanelTitle() {
        return this.getText("_package_description");
    }

    public void lastPanel() {
    }

    public void nextPanel() throws NotContinueWizardException {
        if (!this.packageInfoPanel.validatePanel()) {
            throw new NotContinueWizardException("", null, false);
        }
        this.packageInfoPanel.panelToPackageInfo((PackageInfo)this.wizard.getPackageInfo());
        PackageManager pkgmgr = ToolsLocator.getPackageManager();
        File fileout = new File(this.wizard.getFolderToPackaging(), "package.info");
        try {
            pkgmgr.writePacakgeInfo(this.wizard.getPackageInfo(), fileout);
        }
        catch (Exception ex) {
            logger.warn("Can't save package information (file=" + fileout.getAbsolutePath() + ").", (Throwable)ex);
            JOptionPane.showMessageDialog(null, Messages.getText((String)"_cant_save_package_information_in_the_selected_folder"), Messages.getText((String)"_Warning"), 1);
        }
    }

    public void updatePanel() {
        this.packageInfoPanel.packageInfoToPanel((PackageInfo)this.wizard.getPackageInfo());
    }
}

