/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableEditor;

public class ClearButtonUtils {
    private static final String CLEAR_BUTTON_NAME = "ClearButton";

    private static ImageIcon getIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        ImageIcon icon = theme.get(name);
        return icon;
    }

    public static boolean hasClearButton(JComponent component) {
        JTextComponent text = ClearButtonUtils.getTextComponent(component);
        for (Component aComponent : text.getComponents()) {
            if (!(aComponent instanceof JButton) || !StringUtils.equalsIgnoreCase((CharSequence)CLEAR_BUTTON_NAME, (CharSequence)aComponent.getName())) continue;
            return true;
        }
        return false;
    }

    public static void addClearButton(JComponent component) {
        ClearButtonUtils.addClearButton(component, null);
    }

    public static void addClearButton(JComponent component, ActionListener action) {
        JTextComponent text = ClearButtonUtils.getTextComponent(component);
        if (text == null) {
            return;
        }
        JPanel panel = null;
        AbstractButton btnClear = null;
        for (Component aComponent : text.getComponents()) {
            if (!(aComponent instanceof ClearButtonPanel)) continue;
            panel = (JPanel)aComponent;
            btnClear = (JButton)panel.getComponent(0);
            for (ActionListener l : btnClear.getActionListeners()) {
                btnClear.removeActionListener(l);
            }
        }
        if (btnClear == null) {
            panel = new ClearButtonPanel();
            btnClear = new JButton(ClearButtonUtils.getIcon("picker-cleartext"));
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            btnClear.setFocusable(false);
            btnClear.setBorderPainted(false);
            btnClear.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 2));
            btnClear.setBorderPainted(false);
            btnClear.setFocusPainted(false);
            btnClear.setContentAreaFilled(false);
            btnClear.setOpaque(false);
            btnClear.setCursor(Cursor.getPredefinedCursor(0));
            btnClear.setName(CLEAR_BUTTON_NAME);
            panel.setOpaque(false);
            panel.setLayout(new BorderLayout());
            panel.add((Component)btnClear, "North");
            panel.setFocusable(false);
            text.setLayout(new BorderLayout());
            text.add((Component)panel, "East");
            AbstractButton button = btnClear;
            text.addPropertyChangeListener(arg_0 -> ClearButtonUtils.lambda$addClearButton$0(text, (JButton)button, arg_0));
        }
        if (action == null) {
            btnClear.addActionListener(e -> {
                if (component instanceof JComboBox) {
                    ((JComboBox)component).setSelectedIndex(-1);
                } else {
                    text.setText("");
                }
            });
        } else {
            btnClear.addActionListener(action);
        }
    }

    public static void removeClearButton(JComponent component) {
        JTextComponent text = ClearButtonUtils.getTextComponent(component);
        for (Component aComponent : text.getComponents()) {
            if (!(aComponent instanceof ClearButtonPanel)) continue;
            JPanel panel = (JPanel)aComponent;
            JButton btnClear = (JButton)panel.getComponent(0);
            for (ActionListener l : btnClear.getActionListeners()) {
                btnClear.removeActionListener(l);
            }
            text.remove(panel);
            return;
        }
    }

    public static JTextComponent getTextComponent(JComponent x) {
        if (x instanceof JTextComponent) {
            return (JTextComponent)x;
        }
        if (x instanceof JComboBox) {
            Component xx = ((JComboBox)x).getEditor().getEditorComponent();
            if (xx instanceof JTextComponent) {
                return (JTextComponent)xx;
            }
            return null;
        }
        if (x instanceof JSpinner) {
            JComponent editor = ((JSpinner)x).getEditor();
            if (editor instanceof NullableEditor) {
                return ((NullableEditor)editor).getTextField();
            }
            if (editor instanceof JSpinner.DefaultEditor) {
                return ((JSpinner.DefaultEditor)editor).getTextField();
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$addClearButton$0(JTextComponent text, JButton button, PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        if (evt.getPropertyName().equalsIgnoreCase("enabled")) {
            boolean enabled = text.isEnabled();
            button.setEnabled(enabled);
        } else if (evt.getPropertyName().equalsIgnoreCase("editable")) {
            boolean editable = text.isEditable();
            button.setEnabled(editable);
        }
    }

    private static class ClearButtonPanel
    extends JPanel {
        private ClearButtonPanel() {
        }
    }
}

