/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.impl.ClearButtonUtils;
import org.gvsig.tools.swing.impl.DefaultZoomDialog;

public class ContextMenuUtils {
    public static void setDefaultContextMenu(JComponent component) {
        ContextMenuUtils.setDefaultContextMenu(component, true, null, null);
    }

    public static void setDefaultContextMenu(JComponent component, boolean addEditorDialog) {
        ContextMenuUtils.setDefaultContextMenu(component, addEditorDialog, null, null);
    }

    public static void setDefaultContextMenu(JComponent component, String title) {
        ContextMenuUtils.setDefaultContextMenu(component, true, title, null);
    }

    public static void setDefaultContextMenu(JComponent component, boolean addTextEditor, String title) {
        ContextMenuUtils.setDefaultContextMenu(component, true, title, null);
    }

    public static void setDefaultContextMenu(JComponent component, boolean addTextEditor, final String title, List<Action> customActions) {
        final JTextComponent text = ClearButtonUtils.getTextComponent(component);
        JPopupMenu popupMenu = new JPopupMenu();
        final I18nManager i18n = ToolsLocator.getI18nManager();
        ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(new DefaultEditorKit().getActions()));
        actions.add(new AbstractAction("text-editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultZoomDialog dialog = new DefaultZoomDialog(text, StringUtils.isBlank((CharSequence)title) ? i18n.getTranslation("text_editor") : title, text.getText(), WindowManager.MODE.DIALOG, null);
                boolean allowEdit = text.isEditable() && text.isEnabled();
                Object x = this.getValue("EDITABLE");
                if (x != null) {
                    allowEdit = DataTypeUtils.toBoolean((Object)x, (boolean)false);
                }
                dialog.setEditable(allowEdit);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                if (allowEdit) {
                    text.setText(dialog.getText());
                }
            }
        });
        Action copyAction = ContextMenuUtils.getAction(text, "copy-to-clipboard");
        Action cutAction = ContextMenuUtils.getAction(text, "cut-to-clipboard");
        Action pasteAction = ContextMenuUtils.getAction(text, "paste-from-clipboard");
        Action selectAllAction = ContextMenuUtils.getAction(text, "select-all");
        Action textEditorAction = ContextMenuUtils.getAction(actions, "text-editor");
        if (copyAction == null) {
            copyAction = ContextMenuUtils.getAction(actions, "copy-to-clipboard");
        }
        if (cutAction == null) {
            cutAction = ContextMenuUtils.getAction(actions, "cut-to-clipboard");
        }
        if (pasteAction == null) {
            pasteAction = ContextMenuUtils.getAction(actions, "paste-from-clipboard");
        }
        if (selectAllAction == null) {
            selectAllAction = ContextMenuUtils.getAction(actions, "select-all");
        }
        if (addTextEditor) {
            popupMenu.add(textEditorAction).setText(i18n.getTranslation("text_editor"));
        }
        popupMenu.addSeparator();
        JMenuItem menuCut = popupMenu.add(cutAction);
        JMenuItem menuCopy = popupMenu.add(copyAction);
        JMenuItem menuPaste = popupMenu.add(pasteAction);
        JMenuItem menuSelectAll = popupMenu.add(selectAllAction);
        menuCut.setText(i18n.getTranslation("cut"));
        menuCopy.setText(i18n.getTranslation("copy"));
        menuPaste.setText(i18n.getTranslation("paste"));
        menuSelectAll.setText(i18n.getTranslation("SelectAll"));
        if (text.isEnabled() && text.isEditable()) {
            menuCut.setEnabled(true);
            menuPaste.setEnabled(true);
        } else {
            menuCut.setEnabled(false);
            menuPaste.setEnabled(false);
        }
        if (customActions != null && !customActions.isEmpty()) {
            popupMenu.addSeparator();
            for (Action customAction : customActions) {
                popupMenu.add(customAction);
            }
        }
        text.addPropertyChangeListener(evt -> {
            if (evt == null) {
                return;
            }
            if (evt.getPropertyName().equalsIgnoreCase("enabled")) {
                boolean enabled = text.isEnabled();
                menuCut.setEnabled(enabled);
                menuPaste.setEnabled(enabled);
            } else if (evt.getPropertyName().equalsIgnoreCase("editable")) {
                boolean editable = text.isEditable();
                menuCut.setEnabled(editable);
                menuPaste.setEnabled(editable);
            }
        });
        text.setComponentPopupMenu(popupMenu);
    }

    private static Action getAction(JTextComponent text, String actionName) {
        Action[] actions;
        for (Action action : actions = text.getActions()) {
            if (!StringUtils.equals((CharSequence)((String)action.getValue("Name")), (CharSequence)actionName)) continue;
            return action;
        }
        return null;
    }

    private static Action getAction(List<Action> actions, String name) {
        for (Action action : actions) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)action.getValue("Name")), (CharSequence)name)) continue;
            return action;
        }
        return null;
    }
}

