/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.swing.impl.DefaultChangeListenerHelper;
import org.gvsig.tools.swing.impl.FilteredListModelImpl;

public class DefaultFilteredListController
implements FilteredListController {
    private final JList list;
    private final JTextComponent text;
    private final JButton button;
    private final ChangeListenerHelper changeListenerHelper;
    private FilteredListModel model;

    public DefaultFilteredListController(JList list, JTextComponent text, JButton button) {
        this.list = list;
        this.text = text;
        this.button = button;
        this.changeListenerHelper = new DefaultChangeListenerHelper();
        this.model = null;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.addClearButton(this.text, e -> {
            this.text.setText("");
            this.getModel().setFilter(null);
            this.changeListenerHelper.fireEvent();
        });
        toolsSwingManager.setDefaultPopupMenu(this.text);
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DefaultFilteredListController.this.getModel().setFilter(DefaultFilteredListController.this.text.getText());
                    DefaultFilteredListController.this.changeListenerHelper.fireEvent();
                }
            }
        });
        this.button.setIcon(this.getIcon("common-filter"));
        if (this.button.getText().equals("...")) {
            this.button.setText("");
        }
        this.button.addActionListener(e -> {
            this.getModel().setFilter(this.text.getText());
            this.changeListenerHelper.fireEvent();
        });
    }

    protected ImageIcon getIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        ImageIcon icon = theme.get(name);
        return icon;
    }

    public FilteredListModel getModel() {
        ListModel model0 = this.list.getModel();
        if (this.model == null) {
            if (model0 instanceof FilteredListModel) {
                this.model = (FilteredListModel)model0;
                this.model.setFilter(this.text.getText());
                return this.model;
            }
            this.model = new FilteredListModelImpl(model0);
            this.model.setFilter(this.text.getText());
            this.list.setModel(this.model);
            return this.model;
        }
        if (this.model == model0) {
            return this.model;
        }
        if (model0 instanceof FilteredListModel) {
            this.model = (FilteredListModel)model0;
            this.model.setFilter(this.text.getText());
            return this.model;
        }
        this.model = new FilteredListModelImpl(model0);
        this.model.setFilter(this.text.getText());
        this.list.setModel(this.model);
        return this.model;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.list.isEnabled();
    }
}

