/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.util.AbstractList;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.FilteredModel;
import org.gvsig.tools.task.AbstractCancellableTask;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

class FilteredListModelImpl
extends AbstractListModel
implements FilteredListModel {
    private ListModel elements;
    private DefaultListModel<LabeledValue> filteredElements;
    private String filter;
    private AbstractCancellableTask th;
    private FilteredModel.FilterFunction filterfn;
    private boolean caseSensitive = false;

    public FilteredListModelImpl(ListModel model) {
        this.elements = model == null ? new DefaultListModel() : model;
        this.filteredElements = new DefaultListModel();
        this.filter = null;
        this.th = null;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.filterfn = (theModel, item, theFilter) -> {
            LabeledValue labeledValue;
            String label;
            if (item == null) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)theFilter)) {
                return true;
            }
            if (CompareUtils.match((String)item.toString(), (String)theFilter)) {
                return true;
            }
            if (item instanceof LabeledValue && (label = (labeledValue = (LabeledValue)item).getLabel()) != null) {
                if (CompareUtils.match((String)label, (String)theFilter)) {
                    return true;
                }
                if (CompareUtils.match((String)i18n.getTranslation(label), (String)theFilter)) {
                    return true;
                }
            }
            return false;
        };
    }

    public void setFilterFunction(FilteredModel.FilterFunction filter) {
        this.filterfn = filter;
    }

    public synchronized ListModel getModel() {
        return this.elements;
    }

    @Override
    public synchronized int getSize() {
        return this.filteredElements.getSize();
    }

    public synchronized void clear() {
        this.elements = new DefaultListModel();
        this.filteredElements = new DefaultListModel();
        this.filter = null;
        this.fireContentsChanged();
    }

    @Override
    public synchronized LabeledValue getElementAt(int index) {
        return this.filteredElements.getElementAt(index);
    }

    public synchronized void addElement(LabeledValue element) {
        if (element == null) {
            return;
        }
        if (!(this.elements instanceof DefaultListModel)) {
            throw new IllegalStateException("The model is unmodifiable.");
        }
        ((DefaultListModel)this.elements).addElement(element);
        if (this.filterfn.test((Object)this, (Object)element, this.filter)) {
            this.filteredElements.addElement(element);
        }
        this.fireContentsChanged();
    }

    public synchronized void addElement(Object element) {
        if (!(element instanceof LabeledValue)) {
            element = new LabeledValueImpl(Objects.toString(element, ""), element);
        }
        this.addElement((LabeledValue)element);
    }

    public synchronized void setFilter(String filter) {
        this.filter = StringUtils.isBlank((CharSequence)filter) ? null : (StringUtils.containsAny((CharSequence)filter, (CharSequence)"*?") ? filter : "*" + filter + "*");
        this.copy(this.elements, this.filteredElements, this.filter);
        this.fireContentsChanged();
    }

    private synchronized void copy(ListModel source, DefaultListModel target, String filter) {
        target.clear();
        for (int i = 0; i < source.getSize(); ++i) {
            Object item = source.getElementAt(i);
            try {
                if (!this.filterfn.test((Object)this, item, filter)) continue;
                target.addElement(item);
                continue;
            }
            catch (Exception e) {
                target.addElement(item);
            }
        }
    }

    private void fireContentsChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.fireContentsChanged());
            return;
        }
        this.fireContentsChanged(this, 0, this.filteredElements.size());
    }

    public String getFilter() {
        return this.filter;
    }

    public void sort(boolean ascending) {
        this.sortBackground(ascending);
    }

    private synchronized void sortBackground(final boolean ascending) {
        if (this.th != null) {
            this.th.cancelRequest();
        }
        this.th = new AbstractCancellableTask("FilteredListModelSorter"){

            public void run() {
                ListModelToListAdapter items = new ListModelToListAdapter(FilteredListModelImpl.this.elements);
                items.sort((o1, o2) -> {
                    String o1string = o1 instanceof LabeledValue ? ((LabeledValue)o1).getLabel() : Objects.toString(o1, "");
                    String o2string = o2 instanceof LabeledValue ? ((LabeledValue)o2).getLabel() : Objects.toString(o2, "");
                    int r = FilteredListModelImpl.this.isCaseSensitive() ? ObjectUtils.compare((Comparable)((Object)o1string), (Comparable)((Object)o2string)) : CompareUtils.compare((String)o2string, (String)o2string);
                    if (ascending) {
                        return r;
                    }
                    return -r;
                });
                if (this.isCancellationRequested()) {
                    return;
                }
                FilteredListModelImpl.this.copy(FilteredListModelImpl.this.elements, FilteredListModelImpl.this.filteredElements, FilteredListModelImpl.this.filter);
                FilteredListModelImpl.this.fireContentsChanged();
            }
        };
        this.th.start();
    }

    public void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private static class ListModelToListAdapter
    extends AbstractList {
        private final ListModel model;

        public ListModelToListAdapter(ListModel model) {
            this.model = model;
        }

        @Override
        public Object get(int index) {
            return this.model.getElementAt(index);
        }

        @Override
        public int size() {
            return this.model.getSize();
        }

        @Override
        public Object set(int index, Object element) {
            if (!(this.model instanceof DefaultListModel)) {
                throw new IllegalStateException("The model is unmodifiable.");
            }
            return ((DefaultListModel)this.model).set(index, element);
        }
    }
}

