/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class TitledSeparator
extends JLabel {
    private Color color;
    private final String title;
    private final Color target;
    private final int height;
    private final int titlePosition;
    private final int titleJustification;

    public TitledSeparator(String title, int height, int titlePosition, int titleJustification) {
        this(title, null, height, titlePosition, titleJustification);
    }

    public TitledSeparator(String _title, Color _target, int _height, int _titlePosition, int _titleJustification) {
        this.title = _title;
        this.target = _target;
        this.height = _height;
        this.titlePosition = _titlePosition;
        this.titleJustification = _titleJustification;
        Icon icon = new Icon(){
            private int width = -1;
            private Paint painter1;
            private Paint painter2;

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int w = c.getWidth();
                if (w != this.width || this.painter1 == null || this.painter2 == null || TitledSeparator.this.color == null) {
                    this.width = w;
                    Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
                    Point2D.Float end = new Point2D.Float(this.width, 0.0f);
                    float[] dist = new float[]{0.0f, 1.0f};
                    TitledSeparator.this.color = TitledSeparator.this.getBackground();
                    TitledSeparator.this.color = TitledSeparator.this.color == null ? UIManager.getColor("Panel.background") : TitledSeparator.this.color;
                    Color tc = TitledSeparator.this.target == null ? TitledSeparator.this.color : TitledSeparator.this.target;
                    this.painter1 = new LinearGradientPaint(start, end, dist, new Color[]{tc.darker(), TitledSeparator.this.color});
                    this.painter2 = new LinearGradientPaint(start, end, dist, new Color[]{tc.brighter(), TitledSeparator.this.color});
                }
                int h = this.getIconHeight() / 2;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setPaint(this.painter1);
                g2.fillRect(x, y, this.width, this.getIconHeight());
                g2.setPaint(this.painter2);
                g2.fillRect(x, y + h, this.width, this.getIconHeight() - h);
                g2.dispose();
            }

            @Override
            public int getIconWidth() {
                return 200;
            }

            @Override
            public int getIconHeight() {
                return TitledSeparator.this.height;
            }
        };
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.height, 0, 0, 0, icon), this.title, this.titleJustification, this.titlePosition));
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getPreferredSize();
        d.width = Short.MAX_VALUE;
        return d;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.color = null;
    }
}

