/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableEditor;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableNumberEditorFormatter;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableSpinnerNumberModel;

public class NullableNumberEditor
extends NullableEditor {
    private static String getDefaultPattern(Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(loc);
        return nf.toPattern();
    }

    public NullableNumberEditor(JSpinner spinner, Class valueClass) {
        this(spinner, NullableNumberEditor.getDefaultPattern(spinner.getLocale()), valueClass);
    }

    public NullableNumberEditor(JSpinner spinner, String decimalFormatPattern, Class valueClass) {
        this(spinner, new DecimalFormat(decimalFormatPattern), valueClass);
    }

    private NullableNumberEditor(JSpinner spinner, DecimalFormat format, Class valueClass) {
        super(spinner);
        if (!(spinner.getModel() instanceof NullableSpinnerNumberModel)) {
            throw new IllegalArgumentException("model not a NullableSpinnerNumberModel");
        }
        NullableSpinnerNumberModel model = (NullableSpinnerNumberModel)spinner.getModel();
        NullableNumberEditorFormatter formatter = new NullableNumberEditorFormatter(model, format, this.getTextField(), valueClass);
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
        JFormattedTextField ftf = this.getTextField();
        ftf.setEditable(true);
        ftf.setFormatterFactory(factory);
        ftf.setHorizontalAlignment(4);
        try {
            String maxString = formatter.valueToString(model.getMinimum());
            String minString = formatter.valueToString(model.getMaximum());
            ftf.setColumns(Math.max(maxString.length(), minString.length()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public DecimalFormat getFormat() {
        return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
    }

    public NullableSpinnerNumberModel getModel() {
        return (NullableSpinnerNumberModel)this.getSpinner().getModel();
    }
}

