/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.button;

import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class JStandardizedButton
extends JButton {
    private static final long serialVersionUID = -1635879317292710725L;
    private static int[][] buttonSizes = new int[][]{{90, 23}, {110, 23}, {135, 23}, {160, 23}};
    private String enableText;
    private String toolTip;

    public JStandardizedButton() {
    }

    public JStandardizedButton(Action action) {
        super(action);
    }

    public JStandardizedButton(Icon icon) {
        super(icon);
    }

    public JStandardizedButton(String text) {
        this.setText(text);
    }

    public JStandardizedButton(String text, Icon icon) {
        super(icon);
        this.setText(text);
    }

    public String getEnableText() {
        return this.enableText;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int i;
        int oldHeight;
        int oldWidth;
        Dimension d = this.getUI().getMinimumSize(this);
        int newWidth = oldWidth = (int)d.getWidth();
        int newHeight = oldHeight = (int)d.getHeight();
        for (i = buttonSizes.length - 1; i >= 0; --i) {
            if (oldWidth >= buttonSizes[i][0]) continue;
            newWidth = buttonSizes[i][0];
        }
        for (i = buttonSizes.length - 1; i >= 0; --i) {
            if (oldHeight >= buttonSizes[i][1]) continue;
            newHeight = buttonSizes[i][1];
        }
        return new Dimension(newWidth, newHeight);
    }

    @Override
    public void setEnabled(boolean aFlag) {
        super.setEnabled(aFlag);
        if (aFlag) {
            this.setToolTipText(this.toolTip);
        } else {
            this.setToolTipText(this.enableText);
        }
    }

    public void setEnableText(String enableText) {
        this.enableText = enableText;
    }

    public void setToolTip(String text) {
        this.toolTip = text;
    }
}

