/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.text;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class JStandardizedTextArea
extends JTextArea {
    private static final long serialVersionUID = -1635879317292710725L;
    private static int[][] textAreaSizes = new int[][]{{22, 25}, {44, 25}, {66, 25}, {88, 25}, {110, 25}, {132, 25}, {154, 25}};
    private String enableText;
    private String toolTip;
    private JLabel iconLabel;
    private int filled = 0;

    public JStandardizedTextArea() {
        this.initSettings();
    }

    private void initSettings() {
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setRows(2);
        this.setLineWrap(true);
        this.setEnabled(true);
        this.setEditable(true);
    }

    public JStandardizedTextArea(Icon icon) {
        this.iconLabel = new JLabel(icon);
        this.initSettings();
    }

    public JStandardizedTextArea(String text) {
        this.setText(text);
        this.initSettings();
    }

    public JStandardizedTextArea(String text, Icon icon) {
        this(icon);
        this.setText(text);
    }

    public String getEnableText() {
        return this.enableText;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        Dimension sz = this.getNewDimension();
        super.setSize(sz);
        super.setPreferredSize(sz);
    }

    private Dimension getNewDimension() {
        int oldHeight;
        int oldWidth;
        Dimension d = this.getUI().getMinimumSize(this);
        int newWidth = oldWidth = (int)d.getWidth();
        int newHeight = oldHeight = (int)d.getHeight();
        int rows = this.getRows();
        if (rows == 0) {
            rows = 1;
        }
        for (int i = textAreaSizes.length - 1; i >= 0; --i) {
            if (oldHeight > textAreaSizes[i][1] * rows) continue;
            newHeight = textAreaSizes[i][1] * rows;
        }
        int textSize = this.getText().trim().length();
        if (textSize < 2) {
            newHeight = textAreaSizes[0][1] * rows;
        }
        newWidth = this.getSuitableTextWidth(textSize, newWidth);
        return new Dimension(newWidth, newHeight);
    }

    private int getSuitableTextWidth(int textWidth, int oldWidth) {
        int newWidth = textAreaSizes[0][0];
        if (oldWidth < 1) {
            return newWidth;
        }
        for (int i = textAreaSizes.length - 1; i >= 0; --i) {
            if (textWidth > textAreaSizes[i][0] && oldWidth > textAreaSizes[i][0]) continue;
            newWidth = textAreaSizes[i][0];
        }
        return newWidth;
    }

    @Override
    public void setEnabled(boolean aFlag) {
        super.setEnabled(aFlag);
        if (aFlag) {
            this.setToolTipText(this.toolTip);
        } else {
            this.setToolTipText(this.enableText);
        }
    }

    public void setEnableText(String enableText) {
        this.enableText = enableText;
    }

    public void setToolTip(String text) {
        this.toolTip = text;
    }

    public void setFill(int filledMaximumWidth) {
        this.filled = filledMaximumWidth;
    }
}

