/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.mdiManager;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiFrame.NoSuchMenuException;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.coreplugin.mdiManager.FrameWindowSupport;
import org.gvsig.coreplugin.mdiManager.SingletonWindowSupport;

public class WindowInfoSupport {
    private static int serialId = 0;
    private FrameWindowSupport fws;
    private Hashtable viewInfo = new Hashtable();
    private Hashtable infoView = new Hashtable();
    private WindowPropertyChangeListener windowInfoListener = new WindowPropertyChangeListener();
    private SingletonWindowSupport sws;
    private MainFrame mdiFrame;

    public WindowInfoSupport(MainFrame frame, FrameWindowSupport fvs, SingletonWindowSupport svs) {
        this.fws = fvs;
        this.sws = svs;
        this.mdiFrame = frame;
    }

    public IWindow getWindowById(int id) {
        Enumeration en = this.infoView.keys();
        while (en.hasMoreElements()) {
            WindowInfo vi = (WindowInfo)en.nextElement();
            if (vi.getId() != id) continue;
            return (IWindow)this.infoView.get(vi);
        }
        return null;
    }

    public synchronized WindowInfo getWindowInfo(IWindow w) {
        WindowInfo wi = (WindowInfo)this.viewInfo.get(w);
        if (wi != null) {
            this.fws.updateWindowInfo(w, wi);
        } else {
            wi = w.getWindowInfo();
            if (wi.getHeight() != -1) {
                wi.setHeight(wi.getHeight() + 40);
            }
            wi.addPropertyChangeListener((PropertyChangeListener)this.windowInfoListener);
            this.viewInfo.put(w, wi);
            this.infoView.put(wi, w);
            wi.setId(serialId++);
        }
        return wi;
    }

    public void deleteWindowInfo(IWindow p) {
        WindowInfo vi = (WindowInfo)this.viewInfo.remove(p);
        this.infoView.remove(vi);
    }

    public class WindowPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WindowInfo winInfo = (WindowInfo)evt.getSource();
            IWindow win = (IWindow)WindowInfoSupport.this.infoView.get(winInfo);
            if (win instanceof SingletonWindow) {
                SingletonWindow sw = (SingletonWindow)win;
                if (evt.getPropertyName().equals("x")) {
                    WindowInfoSupport.this.sws.setX(sw, (Integer)evt.getNewValue());
                } else if (evt.getPropertyName().equals("y")) {
                    WindowInfoSupport.this.sws.setY(sw, (Integer)evt.getNewValue());
                } else if (evt.getPropertyName().equals("height")) {
                    WindowInfoSupport.this.sws.setHeight(sw, (Integer)evt.getNewValue());
                } else if (evt.getPropertyName().equals("width")) {
                    WindowInfoSupport.this.sws.setWidth(sw, (Integer)evt.getNewValue());
                } else if (evt.getPropertyName().equals("maximized")) {
                    WindowInfoSupport.this.sws.setMaximized(sw, (Boolean)evt.getNewValue());
                } else if (evt.getPropertyName().equals("normalBounds")) {
                    WindowInfoSupport.this.sws.setNormalBounds(sw, (Rectangle)evt.getNewValue());
                } else if (evt.getPropertyName().equals("minimumSize")) {
                    WindowInfoSupport.this.sws.setMinimumSize(sw, (Dimension)evt.getNewValue());
                } else if (evt.getPropertyName().equals("title")) {
                    WindowInfoSupport.this.sws.setTitle(sw, (String)evt.getNewValue());
                    try {
                        WindowInfoSupport.this.mdiFrame.changeMenuName(new String[]{"Window", (String)evt.getOldValue()}, (String)evt.getNewValue(), (PluginClassLoader)this.getClass().getClassLoader());
                    }
                    catch (NoSuchMenuException noSuchMenuException) {}
                }
            } else if (evt.getPropertyName().equals("x")) {
                WindowInfoSupport.this.fws.setX(win, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("y")) {
                WindowInfoSupport.this.fws.setY(win, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("height")) {
                WindowInfoSupport.this.fws.setHeight(win, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("width")) {
                WindowInfoSupport.this.fws.setWidth(win, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("minimumSize")) {
                WindowInfoSupport.this.fws.setMinimumSize(win, (Dimension)evt.getNewValue());
            } else if (evt.getPropertyName().equals("title")) {
                WindowInfoSupport.this.fws.setTitle(win, (String)evt.getNewValue());
                try {
                    WindowInfoSupport.this.mdiFrame.changeMenuName(new String[]{"Ventana", (String)evt.getOldValue()}, (String)evt.getNewValue(), (PluginClassLoader)this.getClass().getClassLoader());
                }
                catch (NoSuchMenuException noSuchMenuException) {
                    // empty catch block
                }
            }
        }
    }
}

