/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynform.AbstractJDynForm;
import org.gvsig.tools.dynform.spi.dynform.JDynFormFactory;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynform.spi.dynformfield.SupportPopupMenu;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class DefaultJDynForm
extends AbstractJDynForm
implements JDynFormField.JDynFormFieldListener {
    private Map components = new HashMap();
    private final DynFormSPIManager.ComponentsFactory componentsFactory;
    private JComponent fieldsContainer;

    public DefaultJDynForm(DynFormSPIManager manager, JDynFormFactory factory, DynFormDefinition definition, JDynForm.DynFormContext context) {
        super(manager, factory, definition, context);
        this.componentsFactory = manager.createDefaultComponentsFactory();
    }

    public JComponent getFieldsContainer() {
        if (this.fieldsContainer != null) {
            return this.fieldsContainer;
        }
        try {
            JComponent component;
            switch (this.getLayoutMode()) {
                default: {
                    component = this.getFieldsContainerPlain();
                    break;
                }
                case 1: {
                    component = this.getFieldsContainerUseTabs();
                    break;
                }
                case 2: {
                    component = this.getFieldsContainerUseSeparators();
                }
            }
            this.callUserEvent("form_onLoad", new Object[]{this});
            this.fieldsContainer = component;
            return component;
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JComponent getFieldsContainerPlain() throws ServiceException {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 19;
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new GridBagLayout());
        int gridy = 0;
        List fields = this.getDefinition().getDefinitions();
        for (DynFormFieldDefinition fieldDefinition : fields) {
            double weighty;
            if (fieldDefinition.isHidden()) continue;
            JDynFormFieldFactory factory = this.getServiceManager().getJDynFormFieldFactory(this.getContext(), fieldDefinition);
            JDynFormField jfield = factory.create(this.getServiceManager(), this.componentsFactory, fieldDefinition, null);
            if (jfield instanceof AbstractJDynFormField) {
                ((AbstractJDynFormField)jfield).setForm((JDynForm)this);
            }
            jfield.addListener((JDynFormField.JDynFormFieldListener)this);
            if (this.isReadOnly()) {
                jfield.setReadOnly(this.isReadOnly());
            }
            this.configurePopupMenu(jfield);
            String sep = jfield.getSeparatorTitleToUseBefore();
            if (!StringUtils.isBlank((CharSequence)sep)) {
                c.gridx = 0;
                c.gridy = gridy++;
                c.gridwidth = 2;
                c.gridheight = 1;
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                fieldsPanel.add((Component)toolsSwingManager.createTitledSeparator(ToolsLocator.getI18nManager().getTranslation(sep)), c);
            }
            if (jfield.useEmptyLabel()) {
                c.gridx = 0;
                c.gridy = gridy;
                c.gridwidth = 2;
                c.gridheight = 1;
            } else {
                c.gridx = 0;
                c.gridy = gridy;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.fill = 2;
                c.weightx = 0.0;
                c.weighty = 0.0;
                jfield.getJLabel().setAlignmentY(0.0f);
                fieldsPanel.add((Component)jfield.getJLabel(), c);
                c.gridx = 1;
                c.gridy = gridy;
                c.gridwidth = 1;
                c.gridheight = 1;
            }
            if (!jfield.hasClickEvent("compute")) {
                ++c.gridwidth;
            }
            if ((weighty = jfield.getResizeWeight()) > 0.0) {
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = weighty;
                fieldsPanel.add((Component)jfield.asJComponent(), c);
            } else {
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                fieldsPanel.add((Component)jfield.asJComponent(), c);
            }
            if (jfield.hasClickEvent("compute")) {
                c.gridwidth = 1;
                c.fill = 0;
                c.gridx = 2;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.anchor = 10;
                fieldsPanel.add((Component)jfield.getButtonForClickEvent("compute", "_Compute", "common-form-compute"), c);
            }
            this.components.put(jfield.getName(), jfield);
            ++gridy;
        }
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.001;
        fieldsPanel.add((Component)new JLabel(), c);
        return fieldsPanel;
    }

    private JComponent getFieldsContainerUseSeparators() throws ServiceException {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        List groups = this.getDefinition().getGroups();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 19;
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new GridBagLayout());
        int gridy = 0;
        for (String group : groups) {
            boolean firstField = true;
            List fields = this.getDefinition().getDefinitions(group);
            for (DynFormFieldDefinition fieldDefinition : fields) {
                double weighty;
                String sep;
                if (fieldDefinition.isHidden()) continue;
                JDynFormFieldFactory factory = this.getServiceManager().getJDynFormFieldFactory(this.getContext(), fieldDefinition);
                JDynFormField jfield = factory.create(this.getServiceManager(), this.componentsFactory, fieldDefinition, null);
                if (jfield instanceof AbstractJDynFormField) {
                    ((AbstractJDynFormField)jfield).setForm((JDynForm)this);
                }
                jfield.addListener((JDynFormField.JDynFormFieldListener)this);
                if (this.isReadOnly()) {
                    jfield.setReadOnly(this.isReadOnly());
                }
                this.configurePopupMenu(jfield);
                if (firstField) {
                    firstField = false;
                    c.gridx = 0;
                    c.gridy = gridy++;
                    c.gridwidth = 2;
                    c.gridheight = 1;
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)toolsSwingManager.createTitledSeparator(ToolsLocator.getI18nManager().getTranslation(group)), c);
                }
                if (!StringUtils.isBlank((CharSequence)(sep = jfield.getSeparatorTitleToUseBefore()))) {
                    c.gridx = 0;
                    c.gridy = gridy++;
                    c.gridwidth = 2;
                    c.gridheight = 1;
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)toolsSwingManager.createTitledSeparator(ToolsLocator.getI18nManager().getTranslation(sep)), c);
                }
                if (jfield.useEmptyLabel()) {
                    c.gridx = 0;
                    c.gridy = gridy;
                    c.gridwidth = 2;
                    c.gridheight = 1;
                } else {
                    c.gridx = 0;
                    c.gridy = gridy;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.fill = 2;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)jfield.getJLabel(), c);
                    c.gridx = 1;
                    c.gridy = gridy;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                }
                if (!jfield.hasClickEvent("compute")) {
                    ++c.gridwidth;
                }
                if ((weighty = jfield.getResizeWeight()) > 0.0) {
                    c.fill = 1;
                    c.weightx = 1.0;
                    c.weighty = weighty;
                    fieldsPanel.add((Component)jfield.asJComponent(), c);
                } else {
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)jfield.asJComponent(), c);
                }
                if (jfield.hasClickEvent("compute")) {
                    c.gridwidth = 1;
                    c.fill = 0;
                    c.gridx = 2;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)jfield.getButtonForClickEvent("compute", "_Compute", "common-form-compute"), c);
                }
                this.components.put(jfield.getName(), jfield);
                ++gridy;
            }
        }
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.001;
        fieldsPanel.add((Component)new JLabel(), c);
        return fieldsPanel;
    }

    private JComponent getFieldsContainerUseTabs() throws ServiceException {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setTabLayoutPolicy(1);
        if (this.getDefinition().getTags().has("TabPlacement")) {
            try {
                tabbedPane.setTabPlacement(this.getDefinition().getTags().getInt("TabPlacement"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        List groups = this.getDefinition().getGroups();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 19;
        for (String group : groups) {
            JPanel fieldsPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            fieldsPanel.setLayout(gridbag);
            List fields = this.getDefinition().getDefinitions(group);
            int gridy = 0;
            for (DynFormFieldDefinition fieldDefinition : fields) {
                double weighty;
                if (fieldDefinition.isHidden()) continue;
                JDynFormFieldFactory factory = this.getServiceManager().getJDynFormFieldFactory(this.getContext(), fieldDefinition);
                JDynFormField jfield = factory.create(this.getServiceManager(), this.componentsFactory, fieldDefinition, null);
                if (jfield instanceof AbstractJDynFormField) {
                    ((AbstractJDynFormField)jfield).setForm((JDynForm)this);
                }
                jfield.setReadOnly(this.isReadOnly());
                jfield.addListener((JDynFormField.JDynFormFieldListener)this);
                if (this.isReadOnly()) {
                    jfield.setReadOnly(this.isReadOnly());
                }
                this.configurePopupMenu(jfield);
                String sep = jfield.getSeparatorTitleToUseBefore();
                if (!StringUtils.isBlank((CharSequence)sep)) {
                    c.gridx = 0;
                    c.gridy = gridy++;
                    c.gridwidth = 2;
                    c.gridheight = 1;
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)toolsSwingManager.createTitledSeparator(ToolsLocator.getI18nManager().getTranslation(sep)), c);
                }
                if (jfield.useEmptyLabel()) {
                    c.gridx = 0;
                    c.gridy = gridy;
                    c.gridwidth = 2;
                    c.gridheight = 1;
                } else {
                    c.gridx = 0;
                    c.gridy = gridy;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.fill = 2;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    jfield.getJLabel().setAlignmentY(0.0f);
                    fieldsPanel.add((Component)jfield.getJLabel(), c);
                    c.gridx = 1;
                    c.gridy = gridy;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                }
                if (!jfield.hasClickEvent("compute")) {
                    ++c.gridwidth;
                }
                if ((weighty = jfield.getResizeWeight()) > 0.0) {
                    c.fill = 1;
                    c.weightx = 1.0;
                    c.weighty = weighty;
                    fieldsPanel.add((Component)jfield.asJComponent(), c);
                } else {
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)jfield.asJComponent(), c);
                }
                if (jfield.hasClickEvent("compute")) {
                    c.gridwidth = 1;
                    c.fill = 0;
                    c.gridx = 2;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    fieldsPanel.add((Component)jfield.getButtonForClickEvent("compute", "_Compute", "common-form-compute"), c);
                }
                this.components.put(jfield.getName(), jfield);
                ++gridy;
            }
            if (gridy <= 0) continue;
            String tablabel = group;
            tablabel = StringUtils.isBlank((CharSequence)tablabel) ? ToolsLocator.getI18nManager().getTranslation("General") : i18n.getTranslation(tablabel);
            c.gridx = 0;
            c.gridy = gridy;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 3;
            c.weightx = 0.0;
            c.weighty = 0.001;
            fieldsPanel.add((Component)new JLabel(), c);
            tabbedPane.addTab(tablabel, fieldsPanel);
        }
        try {
            String defaultGroupName = (String)this.getDefinition().getTags().get("defaultGroup", 8);
            List groupsNames = this.getDefinition().getGroups();
            int groupIndex = groupsNames.indexOf(defaultGroupName);
            if (groupIndex >= 0) {
                tabbedPane.setSelectedIndex(groupIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tabbedPane;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.isReadOnly() == readOnly) {
            return;
        }
        super.setReadOnly(readOnly);
        if (this.isContentsInitialized()) {
            Iterator it = this.getFieldsIterator();
            while (it.hasNext()) {
                JDynFormField field = (JDynFormField)it.next();
                if (readOnly) {
                    field.setReadOnly(true);
                    continue;
                }
                if (field.getDefinition().isReadOnly()) {
                    field.setReadOnly(true);
                    continue;
                }
                field.setReadOnly(false);
            }
        }
    }

    public void setValues(DynObject values) {
        if (!this.isContentsInitialized()) {
            this.values = values;
            return;
        }
        DynFormDefinition def = this.getDefinition();
        for (DynFormFieldDefinition field : def) {
            if (field.isHidden()) continue;
            String name = field.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                LOGGER.warn("Field name is null or empty ");
                continue;
            }
            JDynFormField jfield = this.getField(name);
            if (jfield == null) {
                LOGGER.warn("Can't retrieve form field asociated to the field '" + name + "' of class '" + def.getName() + "'.");
                continue;
            }
            Object value = values.getDynValue(name);
            if (value == null && field.getDataType().getType() == 34) {
                try {
                    if (field.getDynClassOfItems() != null) {
                        values.setDynValue(name, new ArrayList());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Problems initializing the DynObject List", (Throwable)e);
                }
            }
            jfield.setValue(value);
        }
        this.callUserEvent("form_onSetvalues", new Object[]{this, values});
        try {
            if (((Boolean)this.callUserFunction("form_isReadOnly", new Object[]{this})).booleanValue()) {
                this.setReadOnly(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getValues(DynObject values) {
        DynField[] fields;
        if (values == null) {
            return;
        }
        for (DynField field : fields = values.getDynClass().getDynFields()) {
            String name = field.getName();
            JDynFormField jfield = this.getField(name);
            if (jfield == null || jfield.isReadOnly()) continue;
            try {
                jfield.fetch(values);
            }
            catch (Exception ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Can't get value of field '" + name + "'.", (Throwable)ex);
                    continue;
                }
                LOGGER.info("Can't get value of field '" + name + "'. " + ex.getLocalizedMessage());
            }
        }
    }

    public boolean hasValidValues() {
        Iterator it = this.getFieldsIterator();
        while (it.hasNext()) {
            JDynFormField jfield = (JDynFormField)it.next();
            if (jfield.hasValidValue()) continue;
            return false;
        }
        try {
            return (Boolean)this.callUserFunction("form_validate", new Object[]{this});
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean hasValidValues(List<String> fieldsName) {
        if (fieldsName == null) {
            fieldsName = new ArrayList<String>();
        }
        Iterator it = this.getFieldsIterator();
        while (it.hasNext()) {
            JDynFormField jfield = (JDynFormField)it.next();
            if (jfield.hasValidValue()) continue;
            fieldsName.add(jfield.getName());
        }
        return fieldsName.isEmpty();
    }

    public Object getValue(String fieldName) {
        JDynFormField field = this.getField(fieldName);
        return field.getValue();
    }

    public void setValue(String fieldName, Object value) {
        JDynFormField field = this.getField(fieldName);
        try {
            value = field.getDefinition().getDataType().coerce(value);
        }
        catch (CoercionException e) {
            String msg = "Invalid value '" + (value == null ? "(null)" : value.toString()) + "' for field '" + fieldName + "'.";
            LOGGER.warn(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        field.setValue(value);
    }

    public boolean isModified() {
        if (this.isReadOnly()) {
            return false;
        }
        try {
            if (this.getScript() != null) {
                return (Boolean)this.callUserFunction("form_isModified", new Object[]{this, this.values});
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception ex) {
            LOGGER.warn("Error calling user function form_IsModified.", (Throwable)ex);
        }
        Iterator it = this.getFieldsIterator();
        while (it.hasNext()) {
            JDynFormField jfield = (JDynFormField)it.next();
            if (!jfield.isModified()) continue;
            return true;
        }
        return false;
    }

    public void fieldEnter(JDynFormField field) {
        this.message(field.getDefinition().getDescription());
        this.callUserEvent("form_onFieldEnter", new Object[]{this, field});
    }

    public void fieldExit(JDynFormField field) {
        this.message();
        this.callUserEvent("form_onFieldExit", new Object[]{this, field});
    }

    public void message(JDynFormField field, String message) {
        this.message(message);
    }

    public void fieldChanged(JDynFormField field) {
        this.fireFieldChangeEvent(field);
        this.callUserEvent("form_onFieldChanged", new Object[]{this, field});
    }

    public JDynFormField getField(String fieldName) {
        JDynFormField field = (JDynFormField)this.components.get(fieldName);
        return field;
    }

    public Iterator getFieldsIterator() {
        if (!this.isContentsInitialized()) {
            this.initComponents();
        }
        return this.components.values().iterator();
    }

    public Collection getShowFields() {
        return this.components.values();
    }

    public void clear() {
        for (Map.Entry entry : this.components.entrySet()) {
            ((JDynFormField)entry.getValue()).clear();
        }
        this.callUserEvent("form_clear", new Object[]{this});
    }

    public void addActionToPopupMenu(DataType tipo, String name, Action action) {
        super.addActionToPopupMenu(tipo, name, action);
        if (this.isContentsInitialized()) {
            for (String key : this.components.keySet()) {
                JDynFormField field;
                Object obj = this.components.get(key);
                if (!(obj instanceof JDynFormField) || tipo != (field = (JDynFormField)obj).getDefinition().getDataType() || !(field.asJComponent() instanceof SupportPopupMenu)) continue;
                field.addActionToPopupMenu(name, action);
            }
        }
    }

    public void addSeparatorToPopupMenu(DataType tipo) {
        super.addSeparatorToPopupMenu(tipo);
        if (this.isContentsInitialized()) {
            for (String key : this.components.keySet()) {
                JDynFormField field;
                Object obj = this.components.get(key);
                if (!(obj instanceof JDynFormField) || tipo != (field = (JDynFormField)obj).getDefinition().getDataType() || !(field.asJComponent() instanceof SupportPopupMenu)) continue;
                ((SupportPopupMenu)field.asJComponent()).addSeparatorToPopupMenu();
            }
        }
    }

    public void setBorder(boolean border) {
        super.setBorder(border && this.getShowFields().size() > 1);
    }
}

