/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jdk.sun.awt.geom;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.gvsig.jdk.sun.awt.geom.Curve;

final class Order2
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;

    public static void insert(Vector curves, double[] tmp, double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        int numparams = Order2.getHorizontalParams(y0, cy0, y1, tmp);
        if (numparams == 0) {
            Order2.addInstance(curves, x0, y0, cx0, cy0, x1, y1, direction);
            return;
        }
        double t = tmp[0];
        tmp[0] = x0;
        tmp[1] = y0;
        tmp[2] = cx0;
        tmp[3] = cy0;
        tmp[4] = x1;
        tmp[5] = y1;
        Order2.split(tmp, 0, t);
        int i0 = direction == 1 ? 0 : 4;
        int i1 = 4 - i0;
        Order2.addInstance(curves, tmp[i0], tmp[i0 + 1], tmp[i0 + 2], tmp[i0 + 3], tmp[i0 + 4], tmp[i0 + 5], direction);
        Order2.addInstance(curves, tmp[i1], tmp[i1 + 1], tmp[i1 + 2], tmp[i1 + 3], tmp[i1 + 4], tmp[i1 + 5], direction);
    }

    public static void addInstance(Vector curves, double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        if (y0 > y1) {
            curves.add(new Order2(x1, y1, cx0, cy0, x0, y0, -direction));
        } else if (y1 > y0) {
            curves.add(new Order2(x0, y0, cx0, cy0, x1, y1, direction));
        }
    }

    public static int getHorizontalParams(double c0, double cp, double c1, double[] ret) {
        if (c0 <= cp && cp <= c1) {
            return 0;
        }
        double denom = (c0 -= cp) + (c1 -= cp);
        if (denom == 0.0) {
            return 0;
        }
        double t = c0 / denom;
        if (t <= 0.0 || t >= 1.0) {
            return 0;
        }
        ret[0] = t;
        return 1;
    }

    public static void split(double[] coords, int pos, double t) {
        double y1;
        double x1;
        coords[pos + 8] = x1 = coords[pos + 4];
        coords[pos + 9] = y1 = coords[pos + 5];
        double cx = coords[pos + 2];
        double cy = coords[pos + 3];
        x1 = cx + (x1 - cx) * t;
        y1 = cy + (y1 - cy) * t;
        double x0 = coords[pos + 0];
        double y0 = coords[pos + 1];
        x0 += (cx - x0) * t;
        y0 += (cy - y0) * t;
        cx = x0 + (x1 - x0) * t;
        cy = y0 + (y1 - y0) * t;
        coords[pos + 2] = x0;
        coords[pos + 3] = y0;
        coords[pos + 4] = cx;
        coords[pos + 5] = cy;
        coords[pos + 6] = x1;
        coords[pos + 7] = y1;
    }

    Order2(double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        super(direction);
        if (cy0 < y0) {
            cy0 = y0;
        } else if (cy0 > y1) {
            cy0 = y1;
        }
        this.x0 = x0;
        this.y0 = y0;
        this.cx0 = cx0;
        this.cy0 = cy0;
        this.x1 = x1;
        this.y1 = y1;
        this.xmin = Math.min(Math.min(x0, x1), cx0);
        this.xmax = Math.max(Math.max(x0, x1), cx0);
        this.xcoeff0 = x0;
        this.xcoeff1 = cx0 + cx0 - x0 - x0;
        this.xcoeff2 = x0 - cx0 - cx0 + x1;
        this.ycoeff0 = y0;
        this.ycoeff1 = cy0 + cy0 - y0 - y0;
        this.ycoeff2 = y0 - cy0 - cy0 + y1;
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public double getXTop() {
        return this.x0;
    }

    @Override
    public double getYTop() {
        return this.y0;
    }

    @Override
    public double getXBot() {
        return this.x1;
    }

    @Override
    public double getYBot() {
        return this.y1;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    @Override
    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getCX0() {
        return this.cx0;
    }

    public double getCY0() {
        return this.cy0;
    }

    @Override
    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    @Override
    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    @Override
    public double XforY(double y) {
        if (y <= this.y0) {
            return this.x0;
        }
        if (y >= this.y1) {
            return this.x1;
        }
        return this.XforT(this.TforY(y));
    }

    @Override
    public double TforY(double y) {
        if (y <= this.y0) {
            return 0.0;
        }
        if (y >= this.y1) {
            return 1.0;
        }
        return Order2.TforY(y, this.ycoeff0, this.ycoeff1, this.ycoeff2);
    }

    public static double TforY(double y, double ycoeff0, double ycoeff1, double ycoeff2) {
        double y1;
        double y0;
        ycoeff0 -= y;
        if (ycoeff2 == 0.0) {
            double root = -ycoeff0 / ycoeff1;
            if (root >= 0.0 && root <= 1.0) {
                return root;
            }
        } else {
            double d = ycoeff1 * ycoeff1 - 4.0 * ycoeff2 * ycoeff0;
            if (d >= 0.0) {
                double q;
                double root;
                d = Math.sqrt(d);
                if (ycoeff1 < 0.0) {
                    d = -d;
                }
                if ((root = (q = (ycoeff1 + d) / -2.0) / ycoeff2) >= 0.0 && root <= 1.0) {
                    return root;
                }
                if (q != 0.0 && (root = ycoeff0 / q) >= 0.0 && root <= 1.0) {
                    return root;
                }
            }
        }
        return 0.0 < ((y0 = ycoeff0) + (y1 = ycoeff0 + ycoeff1 + ycoeff2)) / 2.0 ? 0.0 : 1.0;
    }

    @Override
    public double XforT(double t) {
        return (this.xcoeff2 * t + this.xcoeff1) * t + this.xcoeff0;
    }

    @Override
    public double YforT(double t) {
        return (this.ycoeff2 * t + this.ycoeff1) * t + this.ycoeff0;
    }

    @Override
    public double dXforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return (this.xcoeff2 * t + this.xcoeff1) * t + this.xcoeff0;
            }
            case 1: {
                return 2.0 * this.xcoeff2 * t + this.xcoeff1;
            }
            case 2: {
                return 2.0 * this.xcoeff2;
            }
        }
        return 0.0;
    }

    @Override
    public double dYforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return (this.ycoeff2 * t + this.ycoeff1) * t + this.ycoeff0;
            }
            case 1: {
                return 2.0 * this.ycoeff2 * t + this.ycoeff1;
            }
            case 2: {
                return 2.0 * this.ycoeff2;
            }
        }
        return 0.0;
    }

    @Override
    public double nextVertical(double t0, double t1) {
        double t = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (t > t0 && t < t1) {
            return t;
        }
        return t1;
    }

    @Override
    public void enlarge(Rectangle2D r) {
        r.add(this.x0, this.y0);
        double t = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (t > 0.0 && t < 1.0) {
            r.add(this.XforT(t), this.YforT(t));
        }
        r.add(this.x1, this.y1);
    }

    @Override
    public Curve getSubCurve(double ystart, double yend, int dir) {
        int i;
        double t0;
        if (ystart <= this.y0) {
            if (yend >= this.y1) {
                return this.getWithDirection(dir);
            }
            t0 = 0.0;
        } else {
            t0 = Order2.TforY(ystart, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        double t1 = yend >= this.y1 ? 1.0 : Order2.TforY(yend, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        double[] eqn = new double[10];
        eqn[0] = this.x0;
        eqn[1] = this.y0;
        eqn[2] = this.cx0;
        eqn[3] = this.cy0;
        eqn[4] = this.x1;
        eqn[5] = this.y1;
        if (t1 < 1.0) {
            Order2.split(eqn, 0, t1);
        }
        if (t0 <= 0.0) {
            i = 0;
        } else {
            Order2.split(eqn, 0, t0 / t1);
            i = 4;
        }
        return new Order2(eqn[i + 0], ystart, eqn[i + 2], eqn[i + 3], eqn[i + 4], yend, dir);
    }

    @Override
    public Curve getReversedCurve() {
        return new Order2(this.x0, this.y0, this.cx0, this.cy0, this.x1, this.y1, -this.direction);
    }

    @Override
    public int getSegment(double[] coords) {
        coords[0] = this.cx0;
        coords[1] = this.cy0;
        if (this.direction == 1) {
            coords[2] = this.x1;
            coords[3] = this.y1;
        } else {
            coords[2] = this.x0;
            coords[3] = this.y0;
        }
        return 2;
    }

    @Override
    public String controlPointString() {
        return "(" + Order2.round(this.cx0) + ", " + Order2.round(this.cy0) + "), ";
    }
}

