/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.listManager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.utils.listManager.DefaultListModel;
import org.gvsig.utils.listManager.ListManagerListener;
import org.gvsig.utils.listManager.ListModel;
import org.gvsig.utils.listManager.Propertiable;

public class ListManager {
    private JScrollPane jScrollPane = null;
    private JList list = null;
    private JButton btnAdd = null;
    private JButton btnDel = null;
    private JPanel jPanel = null;
    private JButton btnProperties = null;
    private JButton btnUp = null;
    private JButton btnDown = null;
    private ListModel listModel;
    private ListManagerListener listener;
    private ResourceBundle bundle;

    public ListManager(boolean down) {
        this.listModel = new DefaultListModel(down);
    }

    public void initialize() {
        this.actualizar();
    }

    private String getText(String key) {
        if (this.bundle == null) {
            return key;
        }
        String ret = this.bundle.getString(key);
        if (ret == null) {
            ret = key;
        }
        return ret;
    }

    private void actualizar() {
        int index = this.list.getSelectedIndex();
        if (index != -1) {
            if (this.btnUp != null) {
                this.btnUp.setEnabled(index > 0);
            }
            if (this.btnDown != null) {
                this.btnDown.setEnabled(index < this.listModel.getSize() - 1);
            }
            if (this.btnDel != null) {
                this.btnDel.setEnabled(true);
            }
            if (this.btnProperties != null) {
                this.btnProperties.setEnabled(this.listModel.getElementAt(index) instanceof Propertiable);
            }
        } else {
            if (this.btnUp != null) {
                this.btnUp.setEnabled(false);
            }
            if (this.btnDown != null) {
                this.btnDown.setEnabled(false);
            }
            if (this.btnDel != null) {
                this.btnDel.setEnabled(false);
            }
            if (this.btnProperties != null) {
                this.btnProperties.setEnabled(false);
            }
        }
    }

    public void setList(JList list) {
        this.list = list;
        list.setModel(this.listModel);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListManager.this.actualizar();
            }
        });
    }

    public void setBtnAdd(JButton btn) {
        this.btnAdd = btn;
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] objs = ListManager.this.listener.addObjects();
                for (int i = 0; i < objs.length; ++i) {
                    ListManager.this.listModel.add(objs[i]);
                }
                ListManager.this.actualizar();
            }
        });
    }

    public void setBtnDel(JButton btn) {
        this.btnDel = btn;
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = ListManager.this.list.getSelectedIndex();
                ListManager.this.listModel.remove(i);
                if (i < ListManager.this.listModel.getSize()) {
                    ListManager.this.list.setSelectedIndex(i);
                }
                ListManager.this.actualizar();
            }
        });
    }

    public void setBtnProperties(JButton btn) {
        this.btnProperties = btn;
        this.btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ListManager.this.list.getSelectedIndex();
                Object prop = ListManager.this.listener.getProperties(ListManager.this.listModel.getElementAt(index));
                ((Propertiable)ListManager.this.listModel.getElementAt(index)).setProperties(prop);
                ListManager.this.list.repaint();
            }
        });
    }

    public void setBtnUp(JButton btn) {
        this.btnUp = btn;
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ListManager.this.list.getSelectedIndex();
                Object o1 = ListManager.this.listModel.getElementAt(index - 1);
                Object o2 = ListManager.this.listModel.getElementAt(index);
                ListManager.this.listModel.remove(index - 1);
                ListManager.this.listModel.insertAt(index - 1, o2);
                ListManager.this.listModel.remove(index);
                ListManager.this.listModel.insertAt(index, o1);
                ListManager.this.list.setSelectedIndex(index - 1);
            }
        });
    }

    public void setBtnDown(JButton btn) {
        this.btnDown = btn;
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ListManager.this.list.getSelectedIndex();
                Object o = ListManager.this.listModel.remove(index);
                ListManager.this.listModel.insertAt(index + 1, o);
                ListManager.this.list.setSelectedIndex(index + 1);
            }
        });
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public ListManagerListener getListener() {
        return this.listener;
    }

    public void setListener(ListManagerListener listener) {
        this.listener = listener;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

