/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.threads;

import org.gvsig.utils.swing.threads.IMonitorableTask;

public class MonitorableDecoratorMainFirst
implements IMonitorableTask {
    private IMonitorableTask mainTask;
    private IMonitorableTask secondaryTask;
    private IMonitorableTask currentTask;
    private boolean canceled = false;
    private boolean finished = false;

    public MonitorableDecoratorMainFirst(IMonitorableTask mainTask, IMonitorableTask secondaryTask) {
        this.mainTask = mainTask;
        this.secondaryTask = secondaryTask;
        this.currentTask = mainTask;
    }

    public boolean preprocess() {
        return this.mainTask != null && this.secondaryTask != null;
    }

    @Override
    public int getInitialStep() {
        return this.mainTask.getInitialStep();
    }

    @Override
    public int getFinishStep() {
        return this.mainTask.getFinishStep() + 1;
    }

    @Override
    public int getCurrentStep() {
        if (this.currentTask == this.mainTask) {
            return this.mainTask.getCurrentStep();
        }
        return this.getFinishStep();
    }

    @Override
    public String getStatusMessage() {
        return this.mainTask.getStatusMessage();
    }

    @Override
    public String getNote() {
        return this.mainTask.getNote();
    }

    @Override
    public boolean isDefined() {
        return this.mainTask.isDefined();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.currentTask.cancel();
    }

    @Override
    public void run() throws Exception {
        this.currentTask = this.mainTask;
        if (!this.canceled) {
            this.mainTask.run();
        }
        if (!this.canceled) {
            this.currentTask = this.secondaryTask;
            this.secondaryTask.run();
        }
        this.finished = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFinished() {
        if (this.currentTask == this.mainTask) {
            return this.currentTask.isFinished();
        }
        return this.finished;
    }

    @Override
    public void finished() {
    }
}

