/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.xmlViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.gvsig.utils.xmlViewer.XMLContent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLViewer
extends JPanel {
    private JScrollPane jScrollPane = null;
    private JTree xmlTree = null;
    private JScrollPane jScrollPane1 = null;
    private JTable attributeTable = null;
    private JSplitPane jSplitPane = null;
    private JScrollPane jScrollPane2 = null;
    private JTextArea txtContent = null;
    private JSplitPane jSplitPane1 = null;
    private DefaultTreeModel treeModel = null;
    private XMLContent content;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private String[] namesColumn;

    public XMLViewer() {
        this.initialize();
    }

    public synchronized void setModel(XMLContent content) throws SAXException {
        this.content = content;
        this.parse();
    }

    private void parse() throws SAXException {
        MyContentHandler contentHandler = new MyContentHandler();
        this.content.setContentHandler(contentHandler);
        this.content.parse();
        this.treeModel = new DefaultTreeModel(contentHandler.getRoot());
        this.xmlTree.setModel(this.treeModel);
        this.xmlTree.clearSelection();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPane1(), "Center");
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJPanel());
        }
        return this.jScrollPane;
    }

    public JTree getXmlTree() {
        if (this.xmlTree == null) {
            this.xmlTree = new JTree();
            this.xmlTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultTableModel tableModel = new DefaultTableModel();
                    for (int i = 0; i < XMLViewer.this.namesColumn.length; ++i) {
                        tableModel.addColumn(XMLViewer.this.namesColumn[i]);
                    }
                    Node selected = (Node)e.getPath().getLastPathComponent();
                    XMLViewer.this.xmlTree.expandPath(e.getPath());
                    HashMap map = selected.attributes;
                    boolean hasAtts = false;
                    Iterator i = map.keySet().iterator();
                    while (i.hasNext()) {
                        hasAtts = true;
                        Object key = i.next();
                        tableModel.addRow(new Object[]{key, map.get(key)});
                    }
                    XMLViewer.this.getAttributeTable().setModel(tableModel);
                    XMLViewer.this.getAttributeTable().getTableHeader().setVisible(true);
                    if (selected.content == null) {
                        XMLViewer.this.getTxtContent().setVisible(false);
                    } else {
                        XMLViewer.this.getTxtContent().setVisible(true);
                        XMLViewer.this.getTxtContent().setText(selected.content);
                        XMLViewer.this.getTxtContent().setEditable(false);
                        XMLViewer.this.getJSplitPane().setDividerLocation(0);
                    }
                }
            });
        }
        this.xmlTree.setShowsRootHandles(true);
        this.xmlTree.setExpandsSelectedPaths(true);
        return this.xmlTree;
    }

    private JTable getAttributeTable() {
        if (this.attributeTable == null) {
            this.attributeTable = new JTable();
            this.attributeTable.getTableHeader().setVisible(true);
        }
        return this.attributeTable;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getAttributeTable());
        }
        return this.jScrollPane1;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setTopComponent(this.getJScrollPane1());
            this.jSplitPane.setBottomComponent(this.getJScrollPane2());
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setDividerLocation(0.9);
            this.jSplitPane.setResizeWeight(0.9);
            this.jSplitPane.setDividerSize(5);
        }
        return this.jSplitPane;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getTxtContent());
        }
        return this.jScrollPane2;
    }

    private JTextArea getTxtContent() {
        if (this.txtContent == null) {
            this.txtContent = new JTextArea();
        }
        return this.txtContent;
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setLeftComponent(this.getJScrollPane());
            this.jSplitPane1.setRightComponent(this.getJSplitPane());
            this.jSplitPane1.setDividerSize(5);
            this.jSplitPane1.setDividerLocation(0.3);
            this.jSplitPane1.setResizeWeight(0.2);
        }
        return this.jSplitPane1;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getXmlTree(), "Center");
        }
        return this.jPanel;
    }

    public void setNamesColumn(String[] names) {
        this.namesColumn = names;
    }

    public class MyContentHandler
    implements ContentHandler {
        private Stack node = new Stack();
        private boolean betweenTags = false;
        private Node root = null;

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
            this.root = new Node();
            this.node.push(this.root);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.betweenTags) {
                return;
            }
            Node actual = (Node)this.node.peek();
            actual.content = new String(ch, start, length).trim();
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            Node n = (Node)this.node.pop();
            ((Node)this.node.peek()).add(n);
            this.betweenTags = false;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Node nuevo = new Node();
            nuevo.name = qName;
            for (int i = 0; i < atts.getLength(); ++i) {
                nuevo.attributes.put(atts.getQName(i), atts.getValue(i));
            }
            this.node.push(nuevo);
            this.betweenTags = true;
        }

        public Node getRoot() {
            return this.root;
        }
    }

    public class Node
    extends DefaultMutableTreeNode {
        public HashMap attributes = new HashMap();
        public String content;
        public String name;

        @Override
        public String toString() {
            return this.name;
        }
    }
}

