/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.desktopopen;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.desktopopen.DesktopOpen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDesktopOpen
implements DesktopOpen {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultDesktopOpen.class);

    public boolean browse(URI uri) {
        if (this.browseDESKTOP(uri)) {
            return true;
        }
        return this.openSystemSpecific(uri.toString());
    }

    public boolean open(File file) {
        EnumOS os = this.getOs();
        if (os.isLinux()) {
            if (!this.openSystemSpecific(file.getPath())) {
                return this.openDESKTOP(file);
            }
            return true;
        }
        if (this.openDESKTOP(file)) {
            return true;
        }
        return this.openSystemSpecific(file.getPath());
    }

    public boolean edit(File file) {
        if (this.editDESKTOP(file)) {
            return true;
        }
        return this.openSystemSpecific(file.getPath());
    }

    private boolean openSystemSpecific(String what) {
        EnumOS os = this.getOs();
        if (os.isLinux() && this.runCommand("xdg-open", "%s", what)) {
            return true;
        }
        if (os.isMac() && this.runCommand(new String[]{"open", what})) {
            return true;
        }
        return os.isWindows() && this.runCommand(new String[]{"explorer", what});
    }

    private boolean browseDESKTOP(URI uri) {
        LOGGER.info("Trying to use Desktop.getDesktop().browse() with " + uri.toString());
        try {
            if (!Desktop.isDesktopSupported()) {
                LOGGER.warn("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                LOGGER.warn("BROWSE is not supported.");
                return false;
            }
            Desktop.getDesktop().browse(uri);
            return true;
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Error using desktop browse.", t);
            } else {
                LOGGER.warn("Error using Desktop.getDesktop().browse(). " + t.toString());
            }
            return false;
        }
    }

    private boolean openDESKTOP(File file) {
        LOGGER.info("Trying to use Desktop.getDesktop().open() with " + file.toString());
        try {
            if (!Desktop.isDesktopSupported()) {
                LOGGER.warn("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                LOGGER.warn("OPEN is not supported.");
                return false;
            }
            Desktop.getDesktop().open(file);
            return true;
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Error using desktop open.", t);
            } else {
                LOGGER.warn("Error using Desktop.getDesktop().open(). " + t.toString());
            }
            return false;
        }
    }

    private boolean editDESKTOP(File file) {
        LOGGER.info("Trying to use Desktop.getDesktop().edit() with " + file);
        try {
            if (!Desktop.isDesktopSupported()) {
                LOGGER.warn("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                LOGGER.warn("EDIT is not supported.");
                return false;
            }
            Desktop.getDesktop().edit(file);
            return true;
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Error using desktop edit.", t);
            } else {
                LOGGER.warn("Error using Desktop.getDesktop().edit(). " + t.toString());
            }
            return false;
        }
    }

    private boolean runCommand(String command, String args, String file) {
        String[] parts = this.prepareCommand(command, args, file);
        return this.runCommand(parts);
    }

    private boolean runCommand(String[] cmdarray) {
        LOGGER.info("Trying to exec:\n   " + StringUtils.join((Object[])cmdarray, (String)","));
        try {
            Map<String, String> env = System.getenv();
            String[] envp = new String[env.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (StringUtils.equals((CharSequence)key, (CharSequence)"LD_LIBRARY_PATH")) {
                    value = "";
                }
                envp[i++] = key + "=" + value;
            }
            Process p = Runtime.getRuntime().exec(cmdarray, envp);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    LOGGER.warn("Process ended immediately.");
                    return false;
                }
                LOGGER.warn("Process crashed.");
                return false;
            }
            catch (IllegalThreadStateException itse) {
                LOGGER.warn("Process is running.");
                return true;
            }
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Error running command.", (Throwable)e);
            } else {
                LOGGER.warn("Error running command. " + e.toString());
            }
            return false;
        }
    }

    private String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            for (String s : args.split(" ")) {
                s = String.format(s, file);
                parts.add(s.trim());
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    public EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS.linux;
        }
        if (s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public static enum EnumOS {
        linux,
        macos,
        solaris,
        unknown,
        windows;


        public boolean isLinux() {
            return this == linux || this == solaris;
        }

        public boolean isMac() {
            return this == macos;
        }

        public boolean isWindows() {
            return this == windows;
        }
    }
}

