/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.net.URL;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ReplacedText
extends ReplacedContent {
    private static Logger log = LoggerFactory.getLogger(ReplacedText.class);
    private Document doc;
    private URL base;
    private String encoding;
    private DOMAnalyzer decoder;
    private Viewport viewport;
    private Dimension currentDimension;
    private Dimension layoutDimension;

    public ReplacedText(ElementBox owner, Document doc, URL base, String encoding) {
        super(owner);
        this.doc = doc;
        this.base = base;
        this.encoding = encoding;
        this.currentDimension = null;
        this.layoutDimension = null;
        this.createDecoder();
    }

    public Viewport getContentViewport() {
        return this.viewport;
    }

    @Override
    public void draw(Graphics2D g, int width, int height) {
        this.viewport.draw(this.owner.getViewport().getRenderer());
    }

    @Override
    public int getIntrinsicWidth() {
        this.checkLayout();
        return this.viewport.getWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        this.checkLayout();
        return this.viewport.getHeight();
    }

    @Override
    public float getIntrinsicRatio() {
        return (float)this.getIntrinsicWidth() / (float)this.getIntrinsicHeight();
    }

    @Override
    public void doLayout() {
        this.layoutDimension = new Dimension(this.owner.getContent());
        this.checkLayout();
    }

    @Override
    public void absolutePositions() {
        this.viewport.absolutePositions();
    }

    private void createDecoder() {
        this.decoder = new DOMAnalyzer(this.doc, this.base);
        if (this.encoding == null) {
            this.encoding = this.decoder.getCharacterEncoding();
        }
        this.decoder.setDefaultEncoding(this.encoding);
        this.decoder.attributesToStyles();
        this.decoder.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        this.decoder.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        this.decoder.getStyleSheets();
    }

    private Dimension getLayoutDimension() {
        Dimension dim;
        if (this.layoutDimension != null) {
            dim = new Dimension(this.layoutDimension);
            if (dim.width <= 0) {
                dim.width = 10;
            }
            if (dim.height <= 0) {
                dim.height = 10;
            }
        } else {
            dim = new Dimension(10, 10);
        }
        return dim;
    }

    private void checkLayout() {
        Dimension dim = this.getLayoutDimension();
        if (this.currentDimension == null || !this.currentDimension.equals(dim)) {
            this.createLayout(dim);
            BlockBox cblock = this.owner instanceof BlockBox ? (BlockBox)this.owner : this.owner.getContainingBlock();
            this.viewport.setContainingBlock(cblock);
            this.viewport.clipByBlock(cblock);
            this.owner.removeAllSubBoxes();
            this.owner.addSubBox(this.viewport);
            this.currentDimension = new Dimension(dim);
        }
    }

    private void createLayout(Dimension dim) {
        VisualContext ctx = new VisualContext(null, this.getOwner().getViewport().getFactory());
        log.trace("Creating boxes");
        BoxFactory factory = new BoxFactory(this.decoder, this.base);
        factory.setConfig(this.owner.getViewport().getConfig());
        factory.reset();
        this.viewport = factory.createViewportTree(this.decoder.getRoot(), this.owner.getGraphics(), ctx, dim.width, dim.height);
        log.trace("We have " + factory.next_order + " boxes");
        this.viewport.initSubtree();
        log.trace("Layout for " + dim.width + "px");
        this.viewport.doLayout(dim.width, true, true);
        log.trace("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        log.trace("Positioning for " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + "px");
        this.viewport.absolutePositions();
    }
}

