/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;

public class CoerceToLocale
extends AbstractCoercion {
    public static final int LOCALE_DEFAULT_SIZE = 30;
    private static Set<String> availableLanguages = null;

    public static String toString(Locale locale) {
        return locale.toLanguageTag();
    }

    public static boolean isLanguageAvailable(String language) {
        if (language == null || language.isEmpty()) {
            return false;
        }
        if (availableLanguages == null) {
            Locale[] locales;
            availableLanguages = new HashSet<String>();
            for (Locale locale : locales = Locale.getAvailableLocales()) {
                availableLanguages.add(locale.getLanguage());
            }
        }
        return availableLanguages.contains(language);
    }

    public static boolean isValidCountry(String country) {
        if (country == null) {
            return false;
        }
        switch (country.length()) {
            case 2: {
                char ch0 = country.charAt(0);
                char ch1 = country.charAt(1);
                return Character.isUpperCase(ch0) && Character.isAlphabetic(ch0) && Character.isUpperCase(ch1) && Character.isAlphabetic(ch1);
            }
            case 3: {
                char ch0 = country.charAt(0);
                char ch1 = country.charAt(1);
                char ch2 = country.charAt(2);
                return Character.isDigit(ch0) && Character.isDigit(ch1) && Character.isDigit(ch2);
            }
        }
        return false;
    }

    public static Locale parseLocale(String locale_s) {
        String[] locale_p = locale_s.trim().split("_");
        String language = locale_p[0];
        if (!CoerceToLocale.isLanguageAvailable(language)) {
            return null;
        }
        switch (locale_p.length) {
            default: {
                return new Locale(language);
            }
            case 2: {
                String country = locale_p[1];
                if (!CoerceToLocale.isValidCountry(country)) {
                    return null;
                }
                return new Locale(language, country);
            }
            case 3: 
        }
        String country = locale_p[1];
        String variant = locale_p[2];
        if (!CoerceToLocale.isValidCountry(country) || variant.isEmpty()) {
            return null;
        }
        return new Locale(language, country, variant);
    }

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof Locale) {
            return value;
        }
        String locale_s = "";
        try {
            locale_s = value.toString();
            if (locale_s.equalsIgnoreCase("Default")) {
                return Locale.getDefault();
            }
            if (locale_s.equalsIgnoreCase("null")) {
                return null;
            }
            Locale locale = Locale.forLanguageTag(locale_s);
            if (CoerceToLocale.isLanguageAvailable(locale.getLanguage())) {
                return locale;
            }
            locale = CoerceToLocale.parseLocale(locale_s);
            if (locale != null && CoerceToLocale.isLanguageAvailable(locale.getLanguage())) {
                return locale;
            }
        }
        catch (Exception e) {
            throw new CoercionException("Can't coerce '" + locale_s + "' (" + value.getClass().getSimpleName() + ") to Locale.", e);
        }
        throw new CoercionException("Can't coerce '" + locale_s + "' (" + value.getClass().getSimpleName() + ") to Locale.");
    }
}

