/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class CoerceToLong
extends AbstractCoercion {
    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof Long) {
            return value;
        }
        CoercionContextLocale theContext = context instanceof CoercionContextLocale ? (CoercionContextLocale)context : DataTypeUtils.coerceContextDefaultLocale();
        try {
            Number num;
            if (value instanceof Number) {
                num = (Number)value;
            } else if (value instanceof Boolean) {
                num = (Boolean)value != false ? 1L : 0L;
            } else if (value instanceof Date) {
                num = ((Date)value).getTime();
            } else {
                String s = value.toString();
                if (s == null) {
                    return null;
                }
                if ((s = s.trim().toLowerCase()).length() == 0) {
                    return null;
                }
                if (s.startsWith("0x")) {
                    num = Long.valueOf(s.substring(2), 16);
                } else {
                    Boolean bool = BooleanUtils.toBooleanObject((String)s);
                    if (bool != null) {
                        num = bool != false ? 1L : 0L;
                    } else {
                        if (s.startsWith("+")) {
                            s = s.substring(1);
                        }
                        ParsePosition p = new ParsePosition(0);
                        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(theContext.locale());
                        num = nf.parse(s, p);
                        if (p.getErrorIndex() > 0 || p.getIndex() < s.length()) {
                            throw new CoercionException("Can't coerce '" + s + "' to long with locale " + theContext.locale().getLanguage() + "(error index " + p.getErrorIndex() + ", index " + p.getIndex() + ").");
                        }
                    }
                }
            }
            return num.longValue();
        }
        catch (Exception e) {
            throw new CoercionException("Can't coerce '" + value.toString() + "' to long.", e);
        }
    }
}

