/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynFieldIsNotAContainerException;
import org.gvsig.tools.dynobject.exception.DynFieldRequiredValueException;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.dynobject.impl.ValueType;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynField
implements DynField_v2 {
    public static final Logger log = LoggerFactory.getLogger(DefaultDynField.class);
    private String name;
    private String description;
    private ValueType valueType;
    private String subtype;
    private Object defaultValue;
    private Supplier defaultValueSupplier;
    private int order;
    private boolean hidden;
    private String groupName;
    private DynObjectValueItem[] availableValues;
    private DynMethod availableValuesMethod = null;
    private Object minValue;
    private Object maxValue;
    private boolean mandatory;
    private boolean persistent;
    private String label = null;
    private String shortLabel = null;
    private boolean isReadOnly;
    private Tags tags = new DefaultTags();
    private ValueType itemsType;
    private boolean validateItems;
    private int relationType;
    private DynMethod calculate = null;

    public DefaultDynField(String name, int dataType) {
        this(name, dataType, null, true, false);
    }

    protected DefaultDynField(String name, int dataType, Object defaultValue, boolean persistent, boolean mandatory) {
        DataTypesManager datamanager = ToolsLocator.getDataTypesManager();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.name = name;
        this.valueType = new ValueType(dataType);
        this.subtype = this.getSubtype();
        this.defaultValue = defaultValue;
        this.persistent = persistent;
        this.mandatory = mandatory;
        this.groupName = null;
        this.order = 0;
        this.hidden = false;
        this.availableValues = null;
        this.itemsType = new ValueType(0);
        this.validateItems = false;
        this.relationType = 0;
    }

    @Override
    public void copyFrom(DynField other) {
        try {
            this.name = other.getName();
            this.description = other.getDescription();
            if (StringUtils.equals((CharSequence)this.name, (CharSequence)this.description)) {
                this.description = null;
            }
            this.subtype = other.getSubtype();
            this.defaultValue = other.getDefaultValue();
            this.order = other.getOder();
            this.hidden = other.isHidden();
            this.groupName = other.getGroup();
            this.minValue = other.getMinValue();
            this.maxValue = other.getMaxValue();
            this.mandatory = other.isMandatory();
            this.persistent = other.isMandatory();
            this.isReadOnly = other.isReadOnly();
            this.tags = new DefaultTags();
            if (other instanceof DynField_v2) {
                DynField_v2 other2 = (DynField_v2)other;
                this.tags.add(other2.getTags());
                this.label = other2.getLabel();
                if (StringUtils.equals((CharSequence)this.name, (CharSequence)this.label)) {
                    this.label = null;
                }
                this.validateItems = other2.getValidateElements();
                this.defaultValueSupplier = other2.getDefaultValueSupplier();
                if (other2.isCalculated()) {
                    this.setCalculateMethod(other2.getCalculateMethod());
                }
                if (other2.isAvailableValuesCalculated()) {
                    this.availableValuesMethod = other2.getAvailableValuesMethod();
                } else {
                    DynObjectValueItem[] x = other.getAvailableValues();
                    if (x != null) {
                        this.availableValues = (DynObjectValueItem[])x.clone();
                    }
                }
                this.setType(other.getDataType());
                this.setClassOfValue(other2.getClassOfValue());
                this.setClassOfValue(other2.getDynClassOfValue());
                this.itemsType.setType(other2.getTypeOfItems());
                this.itemsType.setClassOfValue(other2.getClassOfItems());
                this.itemsType.setClassOfValue(other2.getDynClassOfItems());
            }
        }
        catch (Exception ex) {
            log.warn("Can't copy dynfield from '" + other.getName() + "'.", (Throwable)ex);
            throw ex;
        }
    }

    protected ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public DynField setCalculateMethod(DynMethod method) {
        this.calculate = method;
        this.persistent = false;
        return this;
    }

    @Override
    public DynMethod getCalculateMethod() {
        return this.calculate;
    }

    @Override
    public boolean isCalculated() {
        return this.calculate != null;
    }

    @Override
    public Object getCalculatedValue(DynObject self) {
        try {
            return this.calculate.invoke(self, new Object[]{this});
        }
        catch (DynMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void check() throws ListBaseException {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DynField").append("[").append(this.hashCode()).append("]").append("( ").append("name='").append(this.name).append("', ").append("description='").append(this.description).append("', ").append("type='").append(this.valueType).append("', ").append("subType='").append(this.subtype).append("', ").append("mandatory='").append(this.isMandatory()).append("', ").append("defaultValue='").append(this.getDefaultValue()).append("', ").append("minValue='").append(this.minValue).append("', ").append("maxValue='").append(this.maxValue).append("', ").append("persistent='").append(this.isPersistent()).append(" )");
        return buffer.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DynField setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.name = name;
        return this;
    }

    @Override
    public DynField setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? this.getLabel() : this.description;
    }

    @Override
    public DynField setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public String getLabel() {
        return StringUtils.isBlank((CharSequence)this.label) ? this.getName() : this.label;
    }

    @Override
    public String getLocalizedLabel() {
        if (StringUtils.isBlank((CharSequence)this.label)) {
            return this.getName();
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation(this.label);
    }

    @Override
    public DynField setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
        return this;
    }

    @Override
    public String getShortLabel() {
        return StringUtils.isBlank((CharSequence)this.shortLabel) ? this.getLabel() : this.shortLabel;
    }

    @Override
    public String getLocalizedShortLabel() {
        if (StringUtils.isBlank((CharSequence)this.shortLabel)) {
            return this.getLocalizedLabel();
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation(this.shortLabel);
    }

    @Override
    public DynField setType(int dataType) {
        this.valueType.setType(dataType);
        return this;
    }

    @Override
    public DynField setType(DataType dataType) {
        this.valueType.setType(dataType);
        return this;
    }

    @Override
    public int getType() {
        return this.valueType.getType();
    }

    @Override
    public DataType getDataType() {
        return this.valueType.getDataType();
    }

    @Override
    public DynField setSubtype(String subtype) {
        this.subtype = subtype;
        if (this.availableValues == null) {
            switch (this.getType()) {
                case 8: {
                    if (StringUtils.equalsIgnoreCase((CharSequence)subtype, (CharSequence)"locale")) {
                        this.availableValues = this.getAvailableLocaleLanguageTags();
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)subtype, (CharSequence)"charset")) break;
                    this.availableValues = this.getAvailableCharsetValues();
                    break;
                }
                case 20: {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)subtype, (CharSequence)"locale")) break;
                    this.availableValues = this.getAvailableLocaleValues();
                }
            }
        }
        return this;
    }

    private DynObjectValueItem[] getAvailableCharsetValues() {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        DynObjectValueItem[] availableValues = new DynObjectValueItem[charsets.size() + 1];
        int i = 0;
        availableValues[i++] = new DynObjectValueItem("DEFAULT", "Default (use system language)");
        for (Map.Entry<String, Charset> entry : charsets.entrySet()) {
            String key = entry.getKey();
            Charset value = entry.getValue();
            availableValues[i++] = new DynObjectValueItem(value, key);
        }
        return availableValues;
    }

    private DynObjectValueItem[] getAvailableLocaleLanguageTags() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, (o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        });
        DynObjectValueItem[] availableValues = new DynObjectValueItem[locales.length + 1];
        availableValues[0] = new DynObjectValueItem("DEFAULT", "Default (use system locale)");
        for (int i = 0; i < locales.length; ++i) {
            String theLabel = locales[i].getDisplayName();
            if (StringUtils.isBlank((CharSequence)theLabel)) {
                theLabel = locales[i].toLanguageTag();
            }
            availableValues[i + 1] = new DynObjectValueItem(locales[i].toLanguageTag(), theLabel);
        }
        return availableValues;
    }

    private DynObjectValueItem[] getAvailableLocaleValues() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, (o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        });
        DynObjectValueItem[] availableValues = new DynObjectValueItem[locales.length + 1];
        availableValues[0] = new DynObjectValueItem("DEFAULT", "Default (use system locale)");
        for (int i = 0; i < locales.length; ++i) {
            String theLabel = locales[i].getDisplayName();
            if (StringUtils.isBlank((CharSequence)theLabel)) {
                theLabel = locales[i].toLanguageTag();
            }
            availableValues[i + 1] = new DynObjectValueItem(locales[i], theLabel);
        }
        return availableValues;
    }

    @Override
    public String getSubtype() {
        return this.subtype;
    }

    @Override
    public DynField setDefaultDynValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValueSupplier != null) {
            return this.defaultValueSupplier.get();
        }
        return this.defaultValue;
    }

    @Override
    public Object getCoercedDefaultValue() {
        DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
        int type = this.getType();
        if (type == 64) {
            try {
                Coercion coercion = dataTypesManager.getDataType(this.getClassOfValue()).getCoercion();
                return coercion.coerce(this.getDefaultValue());
            }
            catch (Exception ex1) {
                return this.getDefaultValue();
            }
        }
        try {
            Coercion coercion = dataTypesManager.getCoercion(this.getType());
            return coercion.coerce(this.getDefaultValue());
        }
        catch (Exception ex) {
            return this.getDefaultValue();
        }
    }

    @Override
    public boolean isAvailableValuesCalculated() {
        return this.availableValuesMethod != null;
    }

    @Override
    public DynField setAvailableValues(DynObjectValueItem[] availableValues) {
        this.availableValues = availableValues == null || availableValues.length == 0 ? null : availableValues;
        return this;
    }

    @Override
    public DynField setAvailableValues(List availableValues) {
        this.availableValues = availableValues == null ? null : (availableValues.isEmpty() ? null : availableValues.toArray(new DynObjectValueItem[availableValues.size()]));
        return this;
    }

    @Override
    public DynField setAvailableValues(DynMethod computeAvailableValues) {
        this.availableValuesMethod = computeAvailableValues;
        return this;
    }

    @Override
    public DynMethod getAvailableValuesMethod() {
        return this.availableValuesMethod;
    }

    @Override
    public DynObjectValueItem[] getAvailableValues() {
        return this.getAvailableValues(null);
    }

    @Override
    public DynObjectValueItem[] getAvailableValues(DynObject context) {
        if (this.availableValuesMethod != null) {
            try {
                Object values = this.availableValuesMethod.invoke(context, new Object[]{this});
                if (values instanceof DynObjectValueItem[]) {
                    return (DynObjectValueItem[])values;
                }
                if (values instanceof GetItem && values instanceof Size) {
                    DynObjectValueItem[] items = new DynObjectValueItem[((Size)values).size()];
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = (DynObjectValueItem)((GetItem)values).get(i);
                    }
                    return items;
                }
            }
            catch (DynMethodException ex) {
                return this.availableValues;
            }
        }
        return this.availableValues;
    }

    @Override
    public DynField setMinValue(Object minValue) {
        try {
            this.minValue = this.coerce(minValue);
        }
        catch (CoercionException e) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    @Override
    public Object getMinValue() {
        return this.minValue;
    }

    @Override
    public DynField setMaxValue(Object maxValue) {
        try {
            this.maxValue = this.coerce(maxValue);
        }
        catch (CoercionException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    public Object getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isPersistent() {
        if (this.isCalculated()) {
            return false;
        }
        return this.persistent;
    }

    @Override
    public DynField setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @Override
    public DynField setPersistent(boolean persistent) {
        if (this.isCalculated()) {
            persistent = false;
        }
        this.persistent = persistent;
        return this;
    }

    @Override
    public DynField setTheTypeOfAvailableValues(int type) {
        return this;
    }

    @Override
    public int getTheTypeOfAvailableValues() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DynField) {
            return this.name.equals(((DynField)obj).getName());
        }
        return false;
    }

    @Override
    public Class getClassOfValue() {
        return this.valueType.getClassOfValue();
    }

    @Override
    public DynField setClassOfValue(Class theClass) {
        this.valueType.setClassOfValue(theClass);
        return this;
    }

    @Override
    public DynField setClassOfValue(String theClassName) {
        this.valueType.setClassOfValue(theClassName);
        return this;
    }

    @Override
    public boolean isContainer() {
        if (this.valueType.getDataType() == null) {
            return false;
        }
        return this.valueType.getDataType().isContainer();
    }

    @Override
    public void validate(Object value) throws DynFieldValidateException {
        if (value == null) {
            if (this.mandatory) {
                throw new DynFieldRequiredValueException(this, value);
            }
            return;
        }
        switch (this.valueType.getType()) {
            case 1: {
                if (value instanceof Boolean) break;
                throw new DynFieldValidateException(value, this);
            }
            case 7: {
                if (value instanceof Double) break;
                throw new DynFieldValidateException(value, this);
            }
            case 6: {
                if (value instanceof Float) break;
                throw new DynFieldValidateException(value, this);
            }
            case 2: {
                if (value instanceof Byte) break;
                throw new DynFieldValidateException(value, this);
            }
            case 4: {
                if (value instanceof Integer) break;
                throw new DynFieldValidateException(value, this);
            }
            case 5: {
                if (value instanceof Long) break;
                throw new DynFieldValidateException(value, this);
            }
            case 8: {
                if (value instanceof String) break;
                throw new DynFieldValidateException(value, this);
            }
            case 3: {
                if (!(value instanceof String)) {
                    throw new DynFieldValidateException(value, this);
                }
                if (((String)value).length() <= 1) break;
                throw new DynFieldValidateException(value, this);
            }
            case 9: {
                if (value instanceof Date) break;
                throw new DynFieldValidateException(value, this);
            }
            case 11: {
                if (value instanceof Date) break;
                throw new DynFieldValidateException(value, this);
            }
            case 10: {
                if (value instanceof Date) break;
                throw new DynFieldValidateException(value, this);
            }
            case 13: {
                if (value instanceof File) break;
                throw new DynFieldValidateException(value, this);
            }
            case 14: {
                if (value instanceof File) break;
                throw new DynFieldValidateException(value, this);
            }
            case 17: {
                if (value instanceof URI) break;
                throw new DynFieldValidateException(value, this);
            }
            case 16: {
                if (value instanceof URL) break;
                throw new DynFieldValidateException(value, this);
            }
            case 33: {
                break;
            }
            case 64: {
                if (this.valueType.getClassOfValue() == null || this.valueType.getClassOfValue().isInstance(value)) break;
                throw new DynFieldValidateException(value, this);
            }
            case 36: {
                if (!(value instanceof Map)) {
                    throw new DynFieldValidateException(value, this);
                }
                this.validateCollection(value);
                break;
            }
            case 35: {
                if (!(value instanceof Set)) {
                    throw new DynFieldValidateException(value, this);
                }
                this.validateCollection(value);
                break;
            }
            case 34: {
                if (!(value instanceof List)) {
                    throw new DynFieldValidateException(value, this);
                }
                this.validateCollection(value);
                break;
            }
            case 15: {
                if (!(value instanceof DynObject)) {
                    throw new DynFieldValidateException(value, this);
                }
                if (!this.getDynClassOfValue().isInstance((DynObject)value)) {
                    throw new DynFieldValidateException(value, this);
                }
                try {
                    this.getDynClassOfValue().validate((DynObject)value);
                    break;
                }
                catch (DynObjectValidateException e) {
                    throw new DynFieldValidateException(value, this, e);
                }
            }
            default: {
                if (!this.valueType.getDataType().isObject() || this.valueType.getClassOfValue() == null || this.valueType.getClassOfValue().isInstance(value)) break;
                throw new DynFieldValidateException(value, this);
            }
        }
        if (this.getAvailableValues() != null) {
            if (!(value instanceof Comparable)) {
                throw new DynFieldValidateException(value, this);
            }
            Comparable v = (Comparable)value;
            boolean ok = false;
            DynObjectValueItem[] theAvailableValues = this.getAvailableValues();
            if (theAvailableValues != null) {
                try {
                    for (DynObjectValueItem availableValue : theAvailableValues) {
                        if (availableValue == null || !(availableValue.getValue() instanceof Comparable) || CompareUtils.compare(v, (Comparable)availableValue.getValue()) != 0) continue;
                        ok = true;
                        break;
                    }
                }
                catch (Exception ex) {
                    log.debug("Can't check if value is in available values (field " + this.getName() + ").", (Throwable)ex);
                }
                if (!ok) {
                    throw new DynFieldValidateException(value, this);
                }
            }
        } else if (this.getMaxValue() != null && this.getMinValue() != null) {
            if (!(value instanceof Comparable)) {
                throw new DynFieldValidateException(value, this);
            }
            Comparable v = (Comparable)value;
            if (v.compareTo(this.minValue) < 0 || v.compareTo(this.maxValue) > 0) {
                throw new DynFieldValidateException(value, this);
            }
        }
    }

    private void validateCollection(Object value) throws ValidateItemException {
        DynStruct dynClass;
        if (this.validateItems && (dynClass = this.itemsType.getDynClassOfValue()) != null) {
            int index = 0;
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                try {
                    dynClass.validate((DynObject)it.next());
                    ++index;
                }
                catch (DynObjectValidateException ex) {
                    throw new ValidateItemException(ex, index);
                }
            }
        }
    }

    @Override
    public Supplier getDefaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    @Override
    public DynField setDefaultValueSupplier(Supplier supplier) {
        this.defaultValueSupplier = supplier;
        return this;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value == null) {
            return value;
        }
        try {
            return this.valueType.getDataType().coerce(value);
        }
        catch (CoercionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CoercionException(ex);
        }
    }

    @Override
    public String getGroup() {
        return this.groupName;
    }

    @Override
    public DynField setGroup(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Override
    public int getOder() {
        return this.order;
    }

    @Override
    public DynField setOrder(int order) {
        this.order = order;
        return this;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public DynField setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public DynField setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    @Override
    public DynField setDefaultFieldValue(Object defaultValue) {
        try {
            this.defaultValue = this.coerce(defaultValue);
        }
        catch (CoercionException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    @Override
    public String getClassNameOfValue() {
        return this.valueType.getClassNameOfValue();
    }

    @Override
    public DynField setClassOfValue(DynStruct dynStruct) {
        this.valueType.setClassOfValue(dynStruct);
        return this;
    }

    @Override
    public DynStruct getDynClassOfValue() {
        return this.valueType.getDynClassOfValue();
    }

    @Override
    public int getRelationType() {
        return this.relationType;
    }

    @Override
    public DynField setRelationType(int relationType) {
        this.relationType = relationType;
        return this;
    }

    @Override
    public DynField setElementsType(int type) {
        this.setTypeOfItems(type);
        return this;
    }

    @Override
    public DynField setElementsType(DynStruct type) {
        this.setClassOfItems(type);
        return this;
    }

    @Override
    public DynField getElementsType() {
        throw new UnsupportedOperationException("This operation is not suported nevermore.");
    }

    @Override
    public DynField setClassOfItems(DynStruct dynStrct) {
        if (dynStrct != null && !this.isContainer()) {
            throw new IllegalStateException("Can't assign classOfItems in non container.");
        }
        this.itemsType.setClassOfValue(dynStrct);
        return this;
    }

    @Override
    public DynField setClassOfItems(String theClassNameOfValue) {
        if (theClassNameOfValue != null && !this.isContainer()) {
            throw new IllegalStateException("Can't assign classOfItems in non container.");
        }
        this.itemsType.setClassOfValue(theClassNameOfValue);
        return this;
    }

    @Override
    public String getClassNameOfItems() {
        if (this.itemsType == null || this.itemsType.getClassNameOfValue() == null) {
            return null;
        }
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't get classNameOfItems in non container.");
        }
        return this.itemsType.getClassNameOfValue();
    }

    @Override
    public DynStruct getDynClassOfItems() {
        if (this.itemsType == null || this.itemsType.getDynClassOfValue() == null) {
            return null;
        }
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't get dynClassOfItems in non container.");
        }
        return this.itemsType.getDynClassOfValue();
    }

    @Override
    public DynField setClassOfItems(Class theClass) throws DynFieldIsNotAContainerException {
        if (theClass != null && !this.isContainer()) {
            throw new IllegalStateException("Can't assign classNameOfItems in non container.");
        }
        this.itemsType.setClassOfValue(theClass);
        return this;
    }

    @Override
    public Class getClassOfItems() {
        if (this.itemsType == null || this.itemsType.getClassOfValue() == null) {
            return null;
        }
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't get classOfItems in non container.");
        }
        return this.itemsType.getClassOfValue();
    }

    @Override
    public DynField setTypeOfItems(int type) {
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't assign typeOfItems in non container.");
        }
        this.itemsType.setType(type);
        return this;
    }

    @Override
    public int getTypeOfItems() {
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't get typeOfItems in non container.");
        }
        return this.itemsType.getType();
    }

    @Override
    public DynField setValidateElements(boolean validate) {
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't assign validateElements in non container.");
        }
        this.validateItems = validate;
        return this;
    }

    @Override
    public boolean getValidateElements() {
        if (!this.isContainer()) {
            throw new IllegalStateException("Can't get validateElements in non container.");
        }
        return this.validateItems;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultDynField other = (DefaultDynField)super.clone();
        other.tags = this.tags.clone();
        other.valueType = (ValueType)this.valueType.clone();
        other.itemsType = (ValueType)this.itemsType.clone();
        other.availableValues = this.availableValues == null ? null : (DynObjectValueItem[])this.availableValues.clone();
        other.calculate = this.calculate;
        return other;
    }

    private static class ValidateItemException
    extends DynFieldValidateException {
        private static final long serialVersionUID = 9011437364983996567L;

        ValidateItemException(Throwable cause, int index) {
            super("Can't validate item %(index) of the collection.", cause, "_Cant_validate_item_%(index)_of_the_collection", 9011437364983996567L);
            this.setValue("index", index);
        }
    }
}

