/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.locator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.impl.DefaultExtensionPointManager;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.locator.LocatorObjectFactory;
import org.gvsig.tools.locator.LocatorReferenceException;
import org.gvsig.tools.locator.Locator_withExists;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocator
implements Locator,
Locator_withExists {
    private Map instances = new HashMap();
    private Logger logger = LoggerFactory.getLogger(AbstractLocator.class);
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String name) throws LocatorException {
        Object instance = null;
        Object object = this.lock;
        synchronized (object) {
            instance = this.instances.get(name);
            if (instance == null) {
                try {
                    instance = this.getExtensionPoint().create(name);
                }
                catch (Exception ex) {
                    throw new LocatorReferenceException(ex, name, this);
                }
                if (instance == null) {
                    this.logger.info("Can't locate class of '" + name + "', may be it is not registered in this locator '" + this.getLocatorName() + "'.");
                    throw new ReferenceNotRegisteredException(name, this);
                }
                this.instances.put(name, instance);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Created and stored the instance of " + name + " in the singleton table (" + instance.getClass().getName() + "/" + instance.toString() + ").");
                }
            }
        }
        return instance;
    }

    @Override
    public boolean exists(String name) {
        ExtensionPoint.Extension extension = this.getExtensionPoint().get(name);
        return extension != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromInstances(String name) {
        Object object = this.lock;
        synchronized (object) {
            Object instance = this.instances.get(name);
            if (instance != null) {
                this.logger.warn("Removing the instance of " + name + " from the singleton table.(" + instance.getClass().getName() + "/" + instance.toString() + ") ");
                this.instances.remove(name);
            }
        }
    }

    @Override
    public String[] getNames() {
        ExtensionPoint extensionPoint = this.getExtensionPoint();
        List names = extensionPoint.getNames();
        return names == null || names.size() == 0 ? null : names.toArray(new String[names.size()]);
    }

    @Override
    public void register(String name, Class clazz) {
        DefaultExtensionPointManager.getManager().add(this.getLocatorName()).append(name, null, clazz);
        this.logger.info("Registered class " + clazz.getName() + " in locator " + name + ".");
        this.removeFromInstances(name);
    }

    @Override
    public void registerDefault(String name, Class clazz) {
        ExtensionPoint ep = this.getExtensionPoint();
        if (ep.get(name) == null) {
            this.register(name, clazz);
        }
    }

    @Override
    public void register(String name, String description, Class clazz) {
        DefaultExtensionPointManager.getManager().add(this.getLocatorName()).append(name, description, clazz);
        this.logger.info("Registered class " + clazz.getName() + " in locator " + name + ".");
        this.removeFromInstances(name);
    }

    @Override
    public void registerDefault(String name, String description, Class clazz) {
        ExtensionPoint ep = this.getExtensionPoint();
        if (ep.get(name) == null) {
            this.register(name, description, clazz);
            this.removeFromInstances(name);
        }
    }

    @Override
    public void register(String name, LocatorObjectFactory factory) {
        DefaultExtensionPointManager.getManager().add(this.getLocatorName()).append(name, null, factory);
        this.logger.info("Registered factory " + factory.getClass().getName() + "/" + factory.toString() + " in locator " + name + ".");
        this.removeFromInstances(name);
    }

    @Override
    public void register(String name, String description, LocatorObjectFactory factory) {
        DefaultExtensionPointManager.getManager().add(this.getLocatorName()).append(name, description, factory);
        this.logger.info("Registered factory " + factory.getClass().getName() + "/" + factory.toString() + " in locator " + name + ".");
        this.removeFromInstances(name);
    }

    public String toString() {
        return this.getLocatorName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionPoint getExtensionPoint() {
        DefaultExtensionPointManager manager = DefaultExtensionPointManager.getManager();
        String moduleName = this.getLocatorName();
        Object object = this.lock;
        synchronized (object) {
            ExtensionPoint extensionPoint = manager.get(moduleName);
            if (extensionPoint == null) {
                extensionPoint = manager.add(moduleName);
            }
            return extensionPoint;
        }
    }
}

