/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.logger;

import org.slf4j.Logger;

public class FilteredLogger {
    protected int count = 0;
    protected final Logger logger;
    protected final int max;
    protected String processName;
    protected long interval;
    protected long lastTime;
    protected boolean showTooManyErrorsMessage;

    public FilteredLogger(Logger logger, String processName, int max) {
        this.max = max;
        this.logger = logger;
        this.processName = processName;
        this.count = 0;
        this.interval = -1L;
        this.lastTime = -1L;
        this.showTooManyErrorsMessage = false;
    }

    public FilteredLogger(Logger logger, String processName, long milis) {
        this(logger, processName, 0);
        this.interval = milis;
    }

    public FilteredLogger setInterval(long interval) {
        this.interval = interval;
        return this;
    }

    protected boolean canDumpMoreMessages() {
        long now = System.currentTimeMillis();
        if (this.max > 0 && this.interval > 0L) {
            if (this.lastTime == 0L) {
                if (++this.count < this.max) {
                    return true;
                }
                if (this.count == this.max) {
                    this.logger.info("Too many messages, don't dump more in this process (" + this.processName + ") until " + this.interval + "ms.");
                    this.lastTime = now;
                }
                return false;
            }
            if (now - this.lastTime > this.interval) {
                return false;
            }
            this.lastTime = 0L;
            this.count = 0;
            return true;
        }
        if (this.interval > 0L) {
            if (this.lastTime < 0L) {
                this.lastTime = now;
                this.showTooManyErrorsMessage = false;
                return true;
            }
            if (now - this.lastTime > this.interval) {
                this.lastTime = now;
                this.showTooManyErrorsMessage = true;
                return true;
            }
            if (this.showTooManyErrorsMessage) {
                this.logger.info("Too many messages, skip some in this process (" + this.processName + ").");
                this.showTooManyErrorsMessage = false;
            }
            return false;
        }
        if (++this.count < this.max) {
            return true;
        }
        if (this.count == this.max) {
            this.logger.info("Too many messages, don't dump more in this process (" + this.processName + ").");
        }
        return false;
    }

    public void warn(String msg, Throwable th) {
        if (this.canDumpMoreMessages()) {
            this.logger.warn(msg, th);
        }
    }

    public void warn(String msg) {
        if (this.canDumpMoreMessages()) {
            this.logger.warn(msg);
        }
    }

    public void error(String msg, Throwable th) {
        if (this.canDumpMoreMessages()) {
            this.logger.error(msg, th);
        }
    }

    public void error(String msg) {
        if (this.canDumpMoreMessages()) {
            this.logger.error(msg);
        }
    }

    public void info(String msg) {
        if (this.canDumpMoreMessages()) {
            this.logger.info(msg);
        }
    }
}

