/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.namestranslator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.namestranslator.AbstractNamesTranslator;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class BaseNamesTranslator
extends AbstractNamesTranslator
implements NamesTranslator,
Persistent {
    protected AbstractNamesTranslator.SimpleMap source2translation;
    protected AbstractNamesTranslator.SimpleMap translation2source;
    protected boolean hasTranslations;
    public static final String DEFAULT_FIELD_NAME = "field";
    protected AbstractNamesTranslator.SimpleList translatedNames;

    public BaseNamesTranslator() {
        this.sourceNames = new AbstractNamesTranslator.SimpleList();
        this.translatedNames = new AbstractNamesTranslator.SimpleList();
    }

    @Override
    public NamesTranslator clone() throws CloneNotSupportedException {
        BaseNamesTranslator clone = (BaseNamesTranslator)super.clone();
        clone.translatedNames = this.translatedNames.clone();
        return clone;
    }

    @Override
    protected void build() {
        this.translatedNames = new AbstractNamesTranslator.SimpleList();
        if (!this.sourceNames.hasUniqueValues()) {
            throw new IllegalArgumentException("Source names contains duplicates.");
        }
        this.hasTranslations = false;
        for (String sourceName : this.sourceNames) {
            String translatedName = this.getSuggestion(sourceName);
            this.translatedNames.add(translatedName);
            if (sourceName.equals(translatedName)) continue;
            this.hasTranslations = true;
        }
        this.source2translation = null;
        this.translation2source = null;
    }

    @Override
    public List<String> getTranslatedNames() {
        return this.translatedNames.toList();
    }

    private void createSource2TranslationMap() {
        this.source2translation = new AbstractNamesTranslator.SimpleMap();
        for (int i = 0; i < this.sourceNames.size(); ++i) {
            if (this.source2translation.toMap().containsKey(this.sourceNames.get(i))) continue;
            this.source2translation.put(this.sourceNames.get(i), this.translatedNames.get(i));
        }
    }

    @Override
    public String getTranslation(String sourceName) {
        if (this.hasTranslations) {
            if (this.source2translation == null) {
                this.createSource2TranslationMap();
            }
            return this.source2translation.get(sourceName);
        }
        return sourceName;
    }

    private void createTranslation2SourceMap() {
        this.translation2source = new AbstractNamesTranslator.SimpleMap();
        for (int i = 0; i < this.sourceNames.size(); ++i) {
            if (this.translation2source.toMap().containsKey(this.translatedNames.get(i))) continue;
            this.translation2source.put(this.translatedNames.get(i), this.sourceNames.get(i));
        }
    }

    @Override
    public String getSource(String translatedName) {
        if (this.hasTranslations) {
            if (this.translation2source == null) {
                this.createTranslation2SourceMap();
            }
            return this.translation2source.get(translatedName);
        }
        return translatedName;
    }

    @Override
    public String getTranslation(int index) {
        return this.translatedNames.get(index);
    }

    @Override
    public int addSource(String sourceName) {
        this.sourceNames.add(sourceName);
        String sugName = this.getSuggestion(sourceName);
        this.translatedNames.add(sugName);
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)sourceName, (CharSequence[])new CharSequence[]{sugName})) {
            this.hasTranslations = true;
        }
        this.source2translation = null;
        this.translation2source = null;
        return this.sourceNames.size() - 1;
    }

    @Override
    public int setTranslation(String sourceName, String translatedName) {
        if (StringUtils.isBlank((CharSequence)sourceName)) {
            throw new IllegalArgumentException("Source name not valid (null or empty string).");
        }
        if (StringUtils.isBlank((CharSequence)translatedName)) {
            throw new IllegalArgumentException("Translated name not valid (null or empty string).");
        }
        int translationToSet = this.sourceNames.indexOf(sourceName);
        int translation = this.setTranslation(translationToSet, translatedName);
        return translation;
    }

    @Override
    public int setTranslation(int sourcePosition, String translatedName) {
        int translationToSet = sourcePosition;
        String sourceName = this.getSource(sourcePosition);
        if (translationToSet < 0) {
            throw new IllegalArgumentException("Don't exist name '" + sourceName + "'.");
        }
        int translationToFix = -1;
        for (int i = 0; i < this.translatedNames.size(); ++i) {
            if (i == translationToSet || !StringUtils.equalsIgnoreCase((CharSequence)translatedName, (CharSequence)this.translatedNames.get(i))) continue;
            translationToFix = i;
            break;
        }
        this.translatedNames.set(translationToSet, translatedName);
        if (!this.hasTranslations) {
            boolean bl = this.hasTranslations = !StringUtils.equalsIgnoreCase((CharSequence)this.translatedNames.get(translationToSet), (CharSequence)this.sourceNames.get(translationToSet));
        }
        if (translationToFix >= 0) {
            this.translatedNames.set(translationToFix, this.getSuggestion(this.sourceNames.get(translationToFix)));
            if (!this.hasTranslations) {
                this.hasTranslations = StringUtils.equalsIgnoreCase((CharSequence)this.translatedNames.get(translationToFix), (CharSequence)this.sourceNames.get(translationToFix));
            }
        }
        this.source2translation = null;
        this.translation2source = null;
        return translationToFix;
    }

    @Override
    public String getSuggestion(String name) {
        String sourceName = name;
        if (StringUtils.isBlank((CharSequence)sourceName)) {
            sourceName = DEFAULT_FIELD_NAME;
        }
        if (!this.translatedNames.contains(sourceName)) {
            return sourceName;
        }
        for (int i = 0; i < 255; ++i) {
            String translatedName = sourceName + i;
            if (this.translatedNames.contains(translatedName)) continue;
            return translatedName;
        }
        return sourceName + "_" + System.currentTimeMillis() % 1000000L;
    }

    @Override
    public boolean isValid(String name) {
        String sourceName = name;
        if (StringUtils.isBlank((CharSequence)sourceName)) {
            sourceName = DEFAULT_FIELD_NAME;
        }
        return !this.translatedNames.contains(sourceName);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("BaseNamesTranslator") == null) {
            DynStruct definition = manager.addDefinition(BaseNamesTranslator.class, "BaseNamesTranslator", "BaseNamesTranslator persistence definition", null, null);
            definition.addDynFieldBoolean("hasTranslations");
            definition.addDynFieldList("translatedNames");
            definition.extend(manager.getDefinition("AbstractNamesTranslator"));
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("hasTranslations", this.hasTranslations);
        state.set("translatedNames", this.translatedNames.toList());
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.hasTranslations = state.getBoolean("hasTranslations");
        List translatedNamesState = state.getList("translatedNames");
        AbstractNamesTranslator.SimpleList translatedNamesList = new AbstractNamesTranslator.SimpleList();
        for (Object object : translatedNamesState) {
            translatedNamesList.add((String)object);
        }
        this.translatedNames = translatedNamesList;
    }

    @Override
    public void rebuild() {
        this.build();
    }

    @Override
    public void updateSourceNames(String[] names) {
        List<String> asList = Arrays.asList(names);
        this.updateSourceNames(asList);
    }

    @Override
    public void updateSourceNames(Iterable<String> names) {
        int i;
        AbstractNamesTranslator.SimpleList oldTranslated;
        AbstractNamesTranslator.SimpleList oldSources;
        AbstractNamesTranslator.SimpleList updateSources = new AbstractNamesTranslator.SimpleList();
        for (String name : names) {
            updateSources.add(name);
        }
        if (this.sourceNames == null) {
            this.sourceNames = updateSources;
            this.rebuild();
            return;
        }
        if (this.sourceNames.isEmpty()) {
            this.sourceNames = updateSources;
            this.rebuild();
            return;
        }
        try {
            oldSources = this.sourceNames.clone();
            oldTranslated = this.translatedNames.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Can't update names into the translator", ex);
        }
        this.sourceNames = updateSources;
        this.rebuild();
        for (i = 0; i < oldSources.size(); ++i) {
            String oldSource = oldSources.get(i);
            if (!this.sourceNames.contains(oldSource)) continue;
            this.setTranslation(oldSource, oldTranslated.get(i));
        }
        for (i = 0; i < this.sourceNames.size(); ++i) {
            String target;
            String source = this.sourceNames.get(i);
            if (StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)(target = this.translatedNames.get(i)))) continue;
            this.hasTranslations = true;
            break;
        }
        this.translation2source = null;
        this.source2translation = null;
    }

    @Override
    public void updateSourceNames(Iterable objs, Function<Object, String> name_getter) {
        AbstractNamesTranslator.SimpleList toUpdate = new AbstractNamesTranslator.SimpleList();
        for (Object obj : objs) {
            String name = name_getter.apply(obj);
            toUpdate.add(name);
        }
        this.updateSourceNames(toUpdate.toList());
    }

    @Override
    public List<String> getAllTranslations(String sourceName) {
        ArrayList<String> toList = new ArrayList<String>();
        if (this.hasTranslations) {
            for (int i = 0; i < this.sourceNames.size(); ++i) {
                String translatorSource = this.sourceNames.get(i);
                if (!translatorSource.equalsIgnoreCase(sourceName)) continue;
                toList.add(this.translatedNames.get(i));
            }
        } else {
            toList.add(this.getTranslation(sourceName));
        }
        return toList;
    }

    @Override
    public void clear() {
        this.sourceNames = new AbstractNamesTranslator.SimpleList();
        this.translatedNames = new AbstractNamesTranslator.SimpleList();
        this.source2translation = null;
        this.translation2source = null;
        this.hasTranslations = false;
    }

    @Override
    public boolean hasDuplicateSources() {
        if (this.source2translation == null) {
            this.createSource2TranslationMap();
        }
        return this.source2translation.size() != this.sourceNames.size();
    }
}

