/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.gvsig.tools.resourcesstorage.AbstractResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class BytesResource
extends AbstractResourcesStorage.AbstractResource
implements ResourcesStorage.Resource {
    private byte[] bytes;
    private ByteArrayOutputStream bos;

    public BytesResource(byte[] bytes) {
        super("");
        this.bytes = bytes;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public InputStream asInputStream() throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bytes);
        return bis;
    }

    @Override
    public OutputStream asOutputStream() throws IOException {
        this.bos = new ByteArrayOutputStream();
        return this.bos;
    }

    @Override
    public void close() {
        if (this.bos != null) {
            this.bytes = this.bos.toByteArray();
            IOUtils.closeQuietly((OutputStream)this.bos);
            this.bos = null;
        }
    }

    public byte[] getBytes() {
        if (this.bos != null) {
            this.bytes = this.bos.toByteArray();
        }
        return this.bytes;
    }
}

