/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.service.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.NotRegisteredException;
import org.gvsig.tools.service.spi.ParametersException;
import org.gvsig.tools.service.spi.Provider;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.service.spi.ProviderManager_WithGetFactories;
import org.gvsig.tools.service.spi.ProviderServices;

public abstract class AbstractProviderManager
implements ProviderManager_WithGetFactories {
    @Override
    public void addProviderFactory(ProviderFactory providerFactory) {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.add(this.getRegistryKey(), this.getRegistryDescription());
        ep.append(providerFactory.getName(), null, providerFactory);
        providerFactory.initialize();
    }

    protected abstract String getRegistryKey();

    protected abstract String getRegistryDescription();

    @Override
    public Provider createProvider(DynObject serviceParameters, ProviderServices providerServices) throws ServiceException {
        String serviceName = serviceParameters.getDynClass().getName();
        ProviderFactory factory = this.getProviderFactory(serviceName);
        return factory == null ? null : factory.create(serviceParameters, providerServices);
    }

    @Override
    public DynObject createServiceParameters(String serviceName) throws ServiceException {
        return this.getProviderFactory(serviceName).createParameters();
    }

    @Override
    public ProviderFactory getProviderFactory(String serviceName) throws ParametersException, NotRegisteredException {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.get(this.getRegistryKey());
        ProviderFactory factory = null;
        if (ep != null) {
            try {
                factory = (ProviderFactory)ep.create(serviceName);
            }
            catch (InstantiationException e) {
                throw new ParametersException("Can't instance provider factory", e);
            }
            catch (IllegalAccessException e) {
                throw new ParametersException("Can't access provider factory", e);
            }
        }
        if (factory == null) {
            throw new NotRegisteredException(serviceName);
        }
        return factory;
    }

    @Override
    public List getProviderFactories() {
        ArrayList<ProviderFactory> factories = new ArrayList<ProviderFactory>();
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.add(this.getRegistryKey(), this.getRegistryDescription());
        Iterator it = ep.iterator();
        while (it.hasNext()) {
            ExtensionPoint.Extension extension = (ExtensionPoint.Extension)it.next();
            try {
                ProviderFactory factory = (ProviderFactory)extension.create();
                factories.add(factory);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return factories;
    }
}

